/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.cloudConnect_bundle_jsonpfunction=self.cloudConnect_bundle_jsonpfunction||[]).push([[75],{75:(e,t,s)=>{s.d(t,{CloudConnectedApp:()=>W});var n=s(286),i=s.n(n),o=s(874),a=s.n(o),c=s(791);const l=(0,n.createContext)(null),r=({value:e,children:t})=>(0,c.jsx)(l.Provider,{value:e},t),d=()=>{const e=(0,n.useContext)(l);if(!e)throw new Error("useCloudConnectedAppContext must be used within CloudConnectedAppContextProvider");return e};var u=s(319),p=s(8);const x=p.i18n.translate("xpack.cloudConnect.name",{defaultMessage:"Cloud Connect"});var g=s(879);const v=p.i18n.translate("xpack.cloudConnect.wizard.step1.title",{defaultMessage:"Sign up or log in to Elastic Cloud and get the Cloud Connect API key"}),m=p.i18n.translate("xpack.cloudConnect.wizard.step1.description",{defaultMessage:"If you already have an Elastic Cloud account with admin privileges, log in to generate the Cloud Connect API key."}),j=p.i18n.translate("xpack.cloudConnect.wizard.step1.description",{defaultMessage:"If you don’t have an account yet, sign up and follow the prompts to create your account and start a free trial, and then generate the Cloud Connect API key."}),C=p.i18n.translate("xpack.cloudConnect.wizard.step2.title",{defaultMessage:"Configure an encryption key"}),f=p.i18n.translate("xpack.cloudConnect.wizard.step3.title",{defaultMessage:"Paste your Cloud Connect API key and connect"}),b=p.i18n.translate("xpack.cloudConnect.wizard.signUpButton",{defaultMessage:"Sign up"}),k=p.i18n.translate("xpack.cloudConnect.wizard.loginButton",{defaultMessage:"Log in"}),E=p.i18n.translate("xpack.cloudConnect.wizard.connectButton",{defaultMessage:"Connect"}),S=p.i18n.translate("xpack.cloudConnect.wizard.apiKeyPlaceholder",{defaultMessage:"Paste your Cloud Connect API key"}),h=({onConnect:e})=>{const{docLinks:t,clusterConfig:s,cloudUrl:o,telemetryService:a,apiService:l}=d(),[r,p]=(0,n.useState)(""),[x,h]=(0,n.useState)(!1),[M,y]=(0,n.useState)(null),w=(e=>{var t,s,n,i,o;if(!e)return"";const a=new URLSearchParams;return null!==(t=e.cluster)&&void 0!==t&&t.id&&a.append("cluster_id",e.cluster.id),null!==(s=e.cluster)&&void 0!==s&&s.name&&a.append("cluster_name",e.cluster.name),null!==(n=e.cluster)&&void 0!==n&&n.version&&a.append("cluster_version",e.cluster.version),null!==(i=e.license)&&void 0!==i&&i.type&&a.append("license_type",e.license.type),null!==(o=e.license)&&void 0!==o&&o.uid&&a.append("license_uid",e.license.uid),a.toString()})(s),F=w?`&${w}`:"",z=encodeURIComponent(w?`/connect-cluster-services?${w}`:"/connect-cluster-services"),T={title:v,titleSize:"xs",status:"incomplete",children:(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiText,{size:"s"},(0,c.jsx)("p",null,m),(0,c.jsx)("p",null,j)),(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"s",responsive:!1},(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiButton,{fill:!0,href:`${o}/registration?onboarding_service_type=ccm${F}`,target:"_blank",iconType:"popout",iconSide:"right",onClick:()=>{a.trackLinkClicked({destination_type:"cloud_signup"})},"data-test-subj":"connectionWizardSignUpButton"},b)),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiButton,{href:`${o}/login?redirectTo=${z}`,target:"_blank",iconType:"popout",iconSide:"right",onClick:()=>{a.trackLinkClicked({destination_type:"cloud_login"})},"data-test-subj":"connectionWizardLoginButton"},k))))},I={title:C,titleSize:"xs",status:"incomplete",children:(0,c.jsx)(u.EuiText,{size:"s","data-test-subj":"connectionWizardEncryptionWarning"},(0,c.jsx)("p",null,(_=t.links.kibana.secureSavedObject,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.wizard.step2.description",defaultMessage:"Configure an {encryptionKeyLink} in Kibana.",values:{encryptionKeyLink:(0,c.jsx)(u.EuiLink,{href:_,target:"_blank"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.wizard.step2.encryptionKeyLink",defaultMessage:"encryption key"}))}}))))};var _;const L={title:f,titleSize:"xs",status:"incomplete",children:(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiText,{size:"s"},(0,c.jsx)("p",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.wizard.step3.description",defaultMessage:"Paste your generated Cloud Connect API key in the following field and click {connect}.",values:{connect:(0,c.jsx)("b",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.wizard.step3.descriptionConnectLabel",defaultMessage:"Connect"}))}}))),(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"s"},(0,c.jsx)(u.EuiFlexItem,null,(0,c.jsx)(u.EuiFieldText,{placeholder:S,value:r,onChange:e=>p(e.target.value),fullWidth:!0,disabled:x||!(null!=s&&s.hasEncryptedSOEnabled),"data-test-subj":"connectionWizardApiKeyInput"})),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiButton,{onClick:async()=>{if(!r.trim())return;h(!0),y(null);const{data:t,error:s}=await l.authenticate(r.trim());if(s)return y(s.message||"Failed to authenticate with Cloud Connect"),void h(!1);null!=t&&t.success&&(a.trackClusterConnected(),e()),h(!1)},disabled:!r.trim()||x||!(null!=s&&s.hasEncryptedSOEnabled),isLoading:x,"data-test-subj":"connectionWizardConnectButton"},E))),M&&(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiCallOut,{title:"Authentication failed",color:"danger",iconType:"error","data-test-subj":"connectionWizardError"},(0,c.jsx)("p",null,M))))},B=null!=s&&s.hasEncryptedSOEnabled?[T,L]:[T,I,L];return(0,c.jsx)(u.EuiSteps,{steps:B})},M=({hasPermissions:e})=>(0,c.jsx)(u.EuiFlexItem,{grow:!e,style:e?{width:"340px"}:void 0},(0,c.jsx)(u.EuiTitle,{size:"s"},(0,c.jsx)("h2",null,p.i18n.translate("xpack.cloudConnect.serviceCards.title",{defaultMessage:"Cloud connected services"}))),(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiFlexGroup,{direction:e?"column":"row",gutterSize:"m"},(0,c.jsx)(u.EuiFlexItem,null,(0,c.jsx)(u.EuiCard,{hasBorder:!0,layout:"horizontal",title:p.i18n.translate("xpack.cloudConnect.serviceCards.autoOps.title",{defaultMessage:"AutoOps"}),description:p.i18n.translate("xpack.cloudConnect.serviceCards.autoOps.description",{defaultMessage:"Get instant cluster diagnostics, performance tips, and cost-saving recommendations—no extra management needed."}),titleSize:"xs"})),(0,c.jsx)(u.EuiFlexItem,null,(0,c.jsx)(u.EuiCard,{hasBorder:!0,layout:"horizontal",title:p.i18n.translate("xpack.cloudConnect.serviceCards.elasticInference.title",{defaultMessage:"Elastic Inference Service"}),description:p.i18n.translate("xpack.cloudConnect.serviceCards.elasticInference.description",{defaultMessage:"Tap into AI-powered search and chat—no ML model deployment or management needed. Fast, scalable, and hassle-free intelligent features."}),titleSize:"xs"})))),y=({onConnect:e})=>{const{http:t,docLinks:s,hasConfigurePermission:n,telemetryService:o}=d();return(0,c.jsx)(u.EuiPageSection,{restrictWidth:1200},(0,c.jsx)(u.EuiFlexGroup,{alignItems:"center",gutterSize:"xl"},(0,c.jsx)(u.EuiFlexItem,null,(0,c.jsx)(u.EuiTitle,{size:"l"},(0,c.jsx)("h1",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.onboarding.pageTitle",defaultMessage:"Get started with Cloud Connect"}))),(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiText,{size:"m"},(0,c.jsx)("p",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.onboarding.pageDescription",defaultMessage:"With Cloud Connect, you can use Elastic Cloud services in your self-managed cluster without having to install and maintain their infrastructure yourself. Get faster access to new features with none of the operational overhead. {learnMoreLink}",values:{learnMoreLink:(0,c.jsx)(u.EuiLink,{href:s.links.cloud.cloudConnect,target:"_blank",rel:"noopener noreferrer",onClick:()=>{o.trackLinkClicked({destination_type:"onboarding_docs"})}},p.i18n.translate("xpack.cloudConnect.onboarding.pageDescription.learnMoreLinkText",{defaultMessage:"Learn more"}))}}))),!n&&(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiText,{color:"subdued",size:"s",style:{fontStyle:"italic"},"data-test-subj":"onboardingPermissionWarning"},(0,c.jsx)("p",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.onboarding.noPermissionsDescription",defaultMessage:"You must have All privileges granted to connect a cluster to Elastic Cloud. Contact your admin to get started."}))))),(0,c.jsx)(u.EuiFlexItem,{style:{width:90},grow:!1}),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiImage,{alt:p.i18n.translate("xpack.cloudConnect.onboarding.illustration.alt",{defaultMessage:"Illustration for cloud data migration"}),src:t.basePath.prepend("/plugins/kibanaReact/assets/")+"illustration_cloud_migration.png",size:"fullWidth",style:{maxWidth:"340px"}}))),(0,c.jsx)(u.EuiSpacer,{size:"xxl"}),(0,c.jsx)(u.EuiFlexGroup,{justifyContent:"spaceBetween"},n&&(0,c.jsx)(u.EuiFlexItem,{grow:!0},(0,c.jsx)("div",{style:{maxWidth:"650px"}},(0,c.jsx)(h,{onConnect:e}))),(0,c.jsx)(M,{hasPermissions:n})))};var w=s(783),F=s.n(w),z=s(770);const T=({subscription:e})=>{const t=e.toLowerCase(),s=(0,z.capitalize)(e);switch(t){case"active":case"trial":return(0,c.jsx)(u.EuiBadge,{color:"success"},s);case"inactive":return(0,c.jsx)(u.EuiToolTip,{position:"bottom",content:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.overview.inactiveSubscriptionInfo",defaultMessage:"This organization has no active cloud subscription or trial. This may mean the trial expired or was never started."})},(0,c.jsx)(u.EuiBadge,{color:"default",iconType:"info",iconSide:"right"},s));default:return(0,c.jsx)(u.EuiBadge,{color:"default"},s)}},I=({organizationId:e,connectedAt:t,subscription:s})=>{const n=F()(t).format("LL");return(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiTitle,{size:"xs"},(0,c.jsx)("h3",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.overview.title",defaultMessage:"Overview"}))),(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"xl",responsive:!1},(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiText,{size:"s"},(0,c.jsx)("strong",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.overview.organizationId",defaultMessage:"Cloud Organization ID"}))," ",e)),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiText,{size:"s"},(0,c.jsx)("strong",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.overview.connectedOn",defaultMessage:"Connected on"}))," ",n)),s&&(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiText,{size:"s"},(0,c.jsx)("strong",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.overview.subscription",defaultMessage:"Cloud subscription"}))," ",(0,c.jsx)(T,{subscription:s})))))},_=({serviceKey:e,title:t,enabled:s,supported:o=!0,badge:a,badgeTooltip:l,region:r,description:x,learnMoreUrl:v,serviceUrl:m,enableServiceByUrl:j,onEnable:C,onDisable:f,onOpen:b,isLoading:k=!1,isCardDisabled:E=!1,subscriptionRequired:S=!1,hasActiveSubscription:h=!0})=>{const{hasConfigurePermission:M,telemetryService:y}=d(),[w,F]=(0,n.useState)(!1),z=()=>F(!1),T=()=>F(!w);return(0,c.jsx)(u.EuiPanel,{hasBorder:!0,paddingSize:"l",color:E?"subdued":"plain"},(0,c.jsx)(u.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"flexStart",responsive:!1},(0,c.jsx)(u.EuiFlexItem,null,(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiTitle,{size:"xs"},(0,c.jsx)("h3",null,t))),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(()=>{if(E&&a)return(0,c.jsx)(u.EuiBetaBadge,{size:"s",label:a,"data-test-subj":"serviceCardComingSoonBadge"});if(!o){const e=(0,c.jsx)(u.EuiBadge,{color:"hollow","data-test-subj":"serviceCardUnsupportedBadge"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.unsupported",defaultMessage:"Unsupported"}));return l?(0,c.jsx)(u.EuiToolTip,{content:l},e):e}return a?(0,c.jsx)(u.EuiBadge,{color:"hollow","data-test-subj":"serviceCardCustomBadge"},a):(0,c.jsx)(u.EuiBadge,{color:s?"success":"subdued","data-test-subj":s?"serviceCardEnabledBadge":"serviceCardDisabledBadge"},s?(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.enabled",defaultMessage:"Enabled"}):(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.notEnabled",defaultMessage:"Not enabled"}))})())),r&&(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiSpacer,{size:"xs"}),(0,c.jsx)(u.EuiText,{size:"s",color:"subdued"},r)),(0,c.jsx)(u.EuiSpacer,{size:"s"}),(0,c.jsx)(u.EuiText,{size:"s",color:"subdued"},x," ",v&&(0,c.jsx)(u.EuiLink,{href:v,target:"_blank",external:!0,onClick:()=>{e&&y.trackLinkClicked({destination_type:"service_documentation",service_type:e})}},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.learnMore",defaultMessage:"Learn more"})))),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(()=>{if(E||!o)return null;if(S&&!h)return(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"xs",alignItems:"center",responsive:!1,"data-test-subj":"serviceCardSubscriptionMessage"},(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiText,{size:"s",color:"subdued"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.requiresSubscription",defaultMessage:"Requires an active cloud subscription"}))),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiIconTip,{content:p.i18n.translate("xpack.cloudConnect.connectedServices.service.subscriptionInfo",{defaultMessage:"Contact your admin to subscribe to Elastic Cloud."}),position:"top"})));if(!M)return(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"xs",alignItems:"center",responsive:!1,"data-test-subj":"serviceCardPermissionMessage"},(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiText,{size:"s",color:"subdued"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.onlyAdminsCanManage",defaultMessage:"Only admins can manage services"}))),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiIconTip,{content:p.i18n.translate("xpack.cloudConnect.connectedServices.service.contactAdmin",{defaultMessage:"Contact your admin"}),position:"top"})));if(s){const t=(0,c.jsx)(u.EuiButtonIcon,{iconType:"boxesHorizontal","aria-label":p.i18n.translate("xpack.cloudConnect.connectedServices.service.moreActions",{defaultMessage:"More actions"}),size:"s",display:"empty",onClick:T,isLoading:k}),s=[(0,c.jsx)(u.EuiContextMenuItem,{key:"disable",onClick:()=>{z(),f&&f()}},(0,c.jsx)(u.EuiText,{size:"s",color:"danger"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.disable",defaultMessage:"Disable service"})))];return(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"s",responsive:!1},m&&(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiButtonEmpty,{size:"s",href:m,target:"_blank",iconSide:"right",iconType:"popout",onClick:()=>{e&&y.trackLinkClicked({destination_type:"service_portal",service_type:e}),b&&b()},disabled:k,isLoading:k,"data-test-subj":"serviceCardOpenButton"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.open",defaultMessage:"Open"}))),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiPopover,{button:t,isOpen:w,closePopover:z,panelPaddingSize:"none",anchorPosition:"downRight","data-test-subj":"serviceCardMoreActionsPopover"},(0,c.jsx)(u.EuiContextMenuPanel,{items:s}))))}return j?(0,c.jsx)(u.EuiButtonEmpty,{size:"s",onClick:C,disabled:!C||k,isLoading:k,iconType:"popout",iconSide:"right","data-test-subj":"serviceCardConnectButton"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.connect",defaultMessage:"Connect"})):(0,c.jsx)(u.EuiButtonEmpty,{size:"s",onClick:C,disabled:!C||k,isLoading:k,"data-test-subj":"serviceCardConnectButton"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.service.connect",defaultMessage:"Connect"}))})())))},L=({serviceName:e,onClose:t,onConfirm:s,isLoading:n})=>(0,c.jsx)(u.EuiConfirmModal,{title:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.services.disable.modalTitle",defaultMessage:"Disable {serviceName}?",values:{serviceName:e}}),onCancel:t,onConfirm:s,cancelButtonText:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.services.disable.cancelButton",defaultMessage:"Cancel"}),confirmButtonText:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.services.disable.confirmButton",defaultMessage:"Disable service"}),buttonColor:"danger",defaultFocusedButton:"cancel",confirmButtonDisabled:n,isLoading:n,"data-test-subj":"disableServiceModal"},(0,c.jsx)("p",{"data-test-subj":"disableServiceModalDescription"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.services.disable.modalDescription",defaultMessage:"Disabling this service will permanently remove all related setup and configuration from your cluster. You can re-enable it later, but your progress will be lost."}))),B=({services:e,onServiceUpdate:t,subscription:s})=>{var o,a,l,r,x,v,m,j,C,f,b,k,E,S,h,M,y,w,F,z,T,I,B,P,D,A,U,O,W,G,K,N,R,q,$,H,Y,V,J,Q;const{loadingService:X,disableModalService:Z,handleEnableService:ee,handleDisableService:te,showDisableModal:se,closeDisableModal:ne,handleEnableServiceByUrl:ie}=(({onServiceUpdate:e,services:t})=>{const{notifications:s,telemetryService:i,apiService:o}=d(),[a,c]=(0,n.useState)(null),[l,r]=(0,n.useState)(null),u=async(n,a)=>{var l;c(n);const{data:r,error:d}=await o.updateServices({[n]:{enabled:a}});if(d)return s.toasts.addDanger({title:a?p.i18n.translate("xpack.cloudConnect.services.enable.errorTitle",{defaultMessage:"Failed to enable service"}):p.i18n.translate("xpack.cloudConnect.services.disable.errorTitle",{defaultMessage:"Failed to disable service"}),text:d.message}),void c(null);null!=r&&r.warning?s.toasts.addWarning({title:a?p.i18n.translate("xpack.cloudConnect.services.enable.warningTitle",{defaultMessage:"Service enabled with warnings"}):p.i18n.translate("xpack.cloudConnect.services.disable.warningTitle",{defaultMessage:"Service disabled with warnings"}),text:r.warning}):s.toasts.addSuccess({title:a?p.i18n.translate("xpack.cloudConnect.services.enable.successTitle",{defaultMessage:"Service enabled successfully"}):p.i18n.translate("xpack.cloudConnect.services.disable.successTitle",{defaultMessage:"Service disabled successfully"})});const u=t[n],x={service_type:n,region_id:null==u||null===(l=u.config)||void 0===l?void 0:l.region_id};a?i.trackServiceEnabled(x):i.trackServiceDisabled(x),c(null),e(n,a)};return{loadingService:a,disableModalService:l,handleEnableService:e=>u(e,!0),handleDisableService:async()=>{l&&(await u(l.key,!1),r(null))},showDisableModal:(e,t)=>{r({key:e,name:t})},closeDisableModal:()=>{r(null)},handleEnableServiceByUrl:(e,t)=>{i.trackLinkClicked({destination_type:"service_enable_url",service_type:e}),window.open(t,"_blank")}}})({onServiceUpdate:t,services:e}),oe="active"===s||"trial"===s,ae=[{serviceKey:"eis",title:p.i18n.translate("xpack.cloudConnect.services.eis.title",{defaultMessage:"Elastic Inference Service"}),enabled:null!==(o=null===(a=e.eis)||void 0===a?void 0:a.enabled)&&void 0!==o&&o,supported:null===(l=null===(r=e.eis)||void 0===r||null===(x=r.support)||void 0===x?void 0:x.supported)||void 0===l||l,badgeTooltip:null!==(v=e.eis)&&void 0!==v&&null!==(m=v.support)&&void 0!==m&&m.supported?void 0:p.i18n.translate("xpack.cloudConnect.services.unsupportedTooltip",{defaultMessage:"This service is not supported with the current cluster configuration."}),region:null!==(j=null===(C=e.eis)||void 0===C||null===(f=C.config)||void 0===f?void 0:f.region_id)&&void 0!==j?j:void 0,description:p.i18n.translate("xpack.cloudConnect.services.eis.description",{defaultMessage:"Tap into AI-powered search and chat—no ML model deployment or management needed."}),learnMoreUrl:null===(b=e.eis)||void 0===b||null===(k=b.metadata)||void 0===k?void 0:k.documentation_url,serviceUrl:null===(E=e.eis)||void 0===E||null===(S=E.metadata)||void 0===S?void 0:S.service_url,onEnable:null!==(h=e.eis)&&void 0!==h&&null!==(M=h.support)&&void 0!==M&&M.supported?()=>ee("eis"):void 0,onDisable:()=>se("eis",p.i18n.translate("xpack.cloudConnect.services.eis.title",{defaultMessage:"Elastic Inference Service"})),isLoading:"eis"===X,subscriptionRequired:null===(y=e.eis)||void 0===y||null===(w=y.subscription)||void 0===w?void 0:w.required,hasActiveSubscription:oe},{serviceKey:"auto_ops",title:p.i18n.translate("xpack.cloudConnect.services.autoOps.title",{defaultMessage:"AutoOps"}),enabled:null!==(F=null===(z=e.auto_ops)||void 0===z?void 0:z.enabled)&&void 0!==F&&F,supported:null===(T=null===(I=e.auto_ops)||void 0===I||null===(B=I.support)||void 0===B?void 0:B.supported)||void 0===T||T,badgeTooltip:null!==(P=e.auto_ops)&&void 0!==P&&null!==(D=P.support)&&void 0!==D&&D.supported?void 0:p.i18n.translate("xpack.cloudConnect.services.unsupportedTooltip",{defaultMessage:"This service is not supported with the current cluster configuration."}),region:null!==(A=null===(U=e.auto_ops)||void 0===U||null===(O=U.config)||void 0===O?void 0:O.region_id)&&void 0!==A?A:void 0,description:p.i18n.translate("xpack.cloudConnect.services.autoOps.description",{defaultMessage:"Get instant cluster diagnostics, performance tips, and cost-saving recommendations—no extra management needed."}),learnMoreUrl:null===(W=e.auto_ops)||void 0===W||null===(G=W.metadata)||void 0===G?void 0:G.documentation_url,serviceUrl:null===(K=e.auto_ops)||void 0===K||null===(N=K.metadata)||void 0===N?void 0:N.service_url,enableServiceByUrl:null===(R=e.auto_ops)||void 0===R||null===(q=R.metadata)||void 0===q?void 0:q.connect_url,onEnable:null!==($=e.auto_ops)&&void 0!==$&&null!==(H=$.support)&&void 0!==H&&H.supported&&null!==(Y=e.auto_ops)&&void 0!==Y&&null!==(V=Y.metadata)&&void 0!==V&&V.connect_url?()=>ie("auto_ops",e.auto_ops.metadata.connect_url):void 0,onDisable:()=>se("auto_ops",p.i18n.translate("xpack.cloudConnect.services.autoOps.title",{defaultMessage:"AutoOps"})),isLoading:"auto_ops"===X,subscriptionRequired:null===(J=e.auto_ops)||void 0===J||null===(Q=J.subscription)||void 0===Q?void 0:Q.required,hasActiveSubscription:oe}],ce=[...ae.filter((e=>e.enabled)),...ae.filter((e=>!e.enabled))];return(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiTitle,{size:"xs"},(0,c.jsx)("h3",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.services.title",defaultMessage:"Services"}))),(0,c.jsx)(u.EuiSpacer,{size:"m"}),ce.map(((e,t)=>(0,c.jsx)(i().Fragment,{key:e.serviceKey},(0,c.jsx)(_,e),t<ce.length-1&&(0,c.jsx)(u.EuiSpacer,{size:"m"})))),Z&&(0,c.jsx)(L,{serviceName:Z.name,onClose:ne,onConfirm:te,isLoading:X===Z.key}))},P=()=>{const{docLinks:e,telemetryService:t}=d(),{euiTheme:s}=(0,u.useEuiTheme)(),n=[{title:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.fasterTimeToValue.title",defaultMessage:"Get faster time to value"}),description:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.fasterTimeToValue.description",defaultMessage:"Deploy in minutes on AWS, Google Cloud, or Azure. Ingest data easily with built-in integrations and analyze everything in Kibana dashboards."})},{title:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.improvePerformance.title",defaultMessage:"Improve performance"}),description:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.improvePerformance.description",defaultMessage:"Scale automatically to match demand and pay only for what you use. Optimize costs with low-cost storage tiers, and replicate/ search data across clouds for speed and reliability"})},{title:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.accessInnovation.title",defaultMessage:"Access innovation"}),description:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.accessInnovation.description",defaultMessage:"Leverage the latest VM types, pick your ideal subscription, integrate with any cloud service, and upgrade with one click to unlock new features."})}];return(0,c.jsx)(i().Fragment,null,(0,c.jsx)(u.EuiSpacer,{size:"xxl"}),(0,c.jsx)(u.EuiFlexGroup,{alignItems:"flexStart",justifyContent:"spaceBetween",responsive:!1},(0,c.jsx)(u.EuiFlexItem,{grow:!1,style:{maxWidth:"50%"}},(0,c.jsx)(u.EuiTitle,{size:"xs"},(0,c.jsx)("h3",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.title",defaultMessage:"Move your self-managed workloads to Elastic Cloud"}))),(0,c.jsx)(u.EuiSpacer,{size:"s"}),(0,c.jsx)(u.EuiText,{size:"s",color:"subdued"},(0,c.jsx)("p",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.description",defaultMessage:"Spin up a deployment and leave managing the infrastructure to us."})))),(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiButton,{color:"text",href:e.links.cloud.cloudConnect,target:"_blank",iconType:"popout",iconSide:"right",onClick:()=>{t.trackLinkClicked({destination_type:"migration_docs"})}},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.migration.learnMore",defaultMessage:"Learn more"})))),(0,c.jsx)(u.EuiSpacer,{size:"l"}),(0,c.jsx)(u.EuiFlexGroup,{gutterSize:"l"},n.map(((e,t)=>(0,c.jsx)(u.EuiFlexItem,{key:t,css:(0,c.css)("@media (min-width: ",s.breakpoint.m,"px){&+&{position:relative;&::before{content:'';position:absolute;left:0;top:50%;transform:translateY(-50%);height:100px;width:1px;background-color:",s.colors.borderBaseSubdued,";z-index:1;}}}","")},(0,c.jsx)(u.EuiCard,{hasBorder:!1,paddingSize:"l",layout:"horizontal",title:e.title,description:e.description,titleSize:"xs",css:(0,c.css)("box-shadow:none!important;",0===t&&"padding-left: 0 !important;","@media (max-width: ",s.breakpoint.m-1,"px){padding-left:0!important;}","")}))))))},D=({clusterName:e,onClose:t,onConfirm:s,isLoading:i})=>{const{telemetryService:o}=d(),[a,l]=(0,n.useState)(""),r=a===e;return(0,c.jsx)(u.EuiModal,{onClose:t,maxWidth:650},(0,c.jsx)(u.EuiModalHeader,null,(0,c.jsx)(u.EuiModalHeaderTitle,{"data-test-subj":"disconnectClusterModalTitle"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.disconnect.modalTitle",defaultMessage:"Disconnect cluster"}))),(0,c.jsx)(u.EuiModalBody,null,(0,c.jsx)(u.EuiCallOut,{title:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.disconnect.warningTitle",defaultMessage:"Disconnecting a cluster cannot be reversed"}),color:"warning",iconType:"warning","data-test-subj":"disconnectClusterWarningCallout"},(0,c.jsx)(u.EuiText,{size:"s"},(0,c.jsx)("p",null,(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.disconnect.warningDescription",defaultMessage:"This action cannot be undone and permanently deletes connection with the cluster {clusterName}. If you proceed, your existing connected services will be disabled and you will lose any data within them.",values:{clusterName:(0,c.jsx)(u.EuiLink,{onClick:t=>{t.currentTarget.blur(),(0,u.copyToClipboard)(e)},"data-test-subj":"disconnectClusterNameLink"},e," ",(0,c.jsx)(u.EuiIcon,{type:"copy"}))}})))),(0,c.jsx)(u.EuiSpacer,{size:"m"}),(0,c.jsx)(u.EuiFormRow,{label:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.disconnect.confirmationLabel",defaultMessage:"Type the cluster ID to confirm"}),fullWidth:!0},(0,c.jsx)(u.EuiFieldText,{placeholder:e,value:a,onChange:e=>l(e.target.value),disabled:i,fullWidth:!0,"aria-label":p.i18n.translate("xpack.cloudConnect.connectedServices.disconnect.confirmationInputAriaLabel",{defaultMessage:"Type the cluster ID to confirm disconnection"}),"data-test-subj":"disconnectClusterConfirmationInput"}))),(0,c.jsx)(u.EuiModalFooter,null,(0,c.jsx)(u.EuiButtonEmpty,{onClick:t,disabled:i,"data-test-subj":"disconnectClusterCancelButton"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.disconnect.cancelButton",defaultMessage:"Cancel"})),(0,c.jsx)(u.EuiButton,{color:"danger",fill:!0,onClick:async()=>{r&&(await s(),o.trackClusterDisconnected())},disabled:!r||i,isLoading:i,"data-test-subj":"disconnectClusterConfirmButton"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.disconnect.confirmButton",defaultMessage:"Disconnect cluster"}))))},A=({clusterDetails:e,onServiceUpdate:t,onDisconnect:s})=>{const{euiTheme:i}=(0,u.useEuiTheme)(),{notifications:o,hasConfigurePermission:a,docLinks:l,telemetryService:r,apiService:x}=d(),[v,m]=(0,n.useState)(!1),[j,C]=(0,n.useState)(!1),[f,b]=(0,n.useState)(!1),k=()=>m(!1),E=()=>{C(!1)},S=[(0,c.jsx)(u.EuiContextMenuItem,{key:"disconnect",onClick:()=>{k(),C(!0)}},(0,c.jsx)(u.EuiText,{color:"danger",size:"s"},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.actions.disconnectCluster",defaultMessage:"Disconnect cluster"})))],h=j?(0,c.jsx)(D,{clusterName:e.name,onClose:E,onConfirm:async()=>{b(!0);const{error:e}=await x.disconnectCluster();if(e)return o.toasts.addDanger({title:p.i18n.translate("xpack.cloudConnect.connectedServices.disconnect.errorTitle",{defaultMessage:"Failed to disconnect cluster"}),text:e.message}),void b(!1);o.toasts.addSuccess({title:p.i18n.translate("xpack.cloudConnect.connectedServices.disconnect.successTitle",{defaultMessage:"Cluster disconnected successfully"}),text:p.i18n.translate("xpack.cloudConnect.connectedServices.disconnect.successMessage",{defaultMessage:"Your cluster has been disconnected from Cloud Connect."})}),E(),s()},isLoading:f}):null,M=(0,c.jsx)(u.EuiButton,{fill:!0,iconType:"arrowDown",iconSide:"right",onClick:()=>m(!v)},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.actionsButton",defaultMessage:"Actions"}));return(0,c.jsx)(u.EuiPage,{direction:"column",restrictWidth:1200,grow:!1,css:(0,c.css)({background:i.colors.backgroundBasePlain},"",""),paddingSize:"l"},(0,c.jsx)(u.EuiPageHeader,{pageTitle:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.pageTitle",defaultMessage:"Cloud connected services"}),bottomBorder:!0,description:(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.pageDescription",defaultMessage:"This cluster is connected to an Elastic Cloud organization. {learnMore}",values:{learnMore:(0,c.jsx)(u.EuiLink,{href:l.links.cloud.cloudConnect,target:"_blank",external:!0,onClick:()=>{r.trackLinkClicked({destination_type:"cloud_connect_docs"})}},(0,c.jsx)(g.FormattedMessage,{id:"xpack.cloudConnect.connectedServices.learnMore",defaultMessage:"Learn more"}))}}),rightSideItems:a?[(0,c.jsx)(u.EuiPopover,{key:"actions",button:M,isOpen:v,closePopover:k,panelPaddingSize:"none",anchorPosition:"downRight"},(0,c.jsx)(u.EuiContextMenuPanel,{items:S}))]:[]}),(0,c.jsx)(u.EuiSpacer,{size:"l"}),(0,c.jsx)(u.EuiPageBody,null,(0,c.jsx)(I,{organizationId:e.metadata.organization_id,connectedAt:e.metadata.created_at,subscription:e.metadata.subscription}),(0,c.jsx)(u.EuiSpacer,{size:"xxl"}),(0,c.jsx)(B,{services:e.services,onServiceUpdate:t,subscription:e.metadata.subscription}),(0,c.jsx)(P,null)),h)},U=()=>{var e;(()=>{const{chrome:e}=d();(0,n.useEffect)((()=>{const t=[{text:"Kibana",href:"/"},{text:x}];e.setBreadcrumbs(t),e.docTitle.change(x)}),[e])})();const t=d(),{notifications:s,apiService:i}=t,{data:o,isLoading:a}=i.useLoadConfig(),{clusterDetails:l,isLoading:p,error:g,handleServiceUpdate:v,handleDisconnect:m,handleConnect:j}=(()=>{const{apiService:e}=d(),{data:t,isLoading:s,error:i,resendRequest:o}=e.useLoadClusterDetails(),[a,c]=(0,n.useState)(null);return(0,n.useEffect)((()=>{t&&c(t)}),[t]),{clusterDetails:a,isLoading:s,error:i,handleServiceUpdate:(e,t)=>{c((s=>((e,t,s)=>e&&e.services[t]?{...e,services:{...e.services,[t]:{...e.services[t],enabled:s}}}:e)(s,e,t)))},handleDisconnect:()=>{c(null)},handleConnect:o}})();if((0,n.useEffect)((()=>{g&&503!==g.statusCode&&s.toasts.addError(g,{title:"Failed to load cluster details"})}),[g,s.toasts]),a||p&&!l)return(0,c.jsx)(u.EuiPage,{restrictWidth:1200},(0,c.jsx)(u.EuiPageBody,null,(0,c.jsx)(u.EuiFlexGroup,{justifyContent:"center",alignItems:"center",style:{minHeight:"50vh"}},(0,c.jsx)(u.EuiFlexItem,{grow:!1},(0,c.jsx)(u.EuiLoadingSpinner,{size:"xl"})))));const C={...t,clusterConfig:o,hasConfigurePermission:!0===(null===(e=t.application.capabilities.cloudConnect)||void 0===e?void 0:e.configure)};return(0,c.jsx)(r,{value:C},(0,c.jsx)(u.EuiPage,null,(0,c.jsx)(u.EuiPageBody,{panelled:!0},l?(0,c.jsx)(A,{clusterDetails:l,onServiceUpdate:v,onDisconnect:m}):(0,c.jsx)(y,{onConnect:j}))))},O=({chrome:e,application:t,http:s,docLinks:n,notifications:i,history:o,cloudUrl:a,telemetryService:l,apiService:d})=>(0,c.jsx)(r,{value:{chrome:e,application:t,http:s,docLinks:n,notifications:i,history:o,cloudUrl:a,telemetryService:l,apiService:d}},(0,c.jsx)(U,null)),W=(e,t,s,n,i)=>(a().render(e.rendering.addContext((0,c.jsx)(O,{chrome:e.chrome,application:e.application,http:e.http,docLinks:e.docLinks,notifications:e.notifications,history:t.history,cloudUrl:s,telemetryService:n,apiService:i})),t.element),()=>a().unmountComponentAtNode(t.element))}}]);