"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserActionsHandler = void 0;
var _react = require("react");
var _navigation = require("../../common/navigation");
var _use_lens_draft_comment = require("../markdown_editor/plugins/lens/use_lens_draft_comment");
var _use_update_comment = require("../../containers/use_update_comment");
var _constants = require("./constants");
var _use_delete_comment = require("../../containers/use_delete_comment");
var _use_on_refresh_case_view_page = require("../case_view/use_on_refresh_case_view_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAddCommentRef = ref => {
  const commentRef = ref;
  return (commentRef === null || commentRef === void 0 ? void 0 : commentRef.addQuote) != null;
};
const isSetCommentRef = ref => {
  const commentRef = ref;
  return (commentRef === null || commentRef === void 0 ? void 0 : commentRef.setComment) != null;
};
const useUserActionsHandler = () => {
  const {
    detailName: caseId
  } = (0, _navigation.useCaseViewParams)();
  const {
    clearDraftComment,
    draftComment,
    hasIncomingLensState,
    openLensModal
  } = (0, _use_lens_draft_comment.useLensDraftComment)();
  const handlerTimeoutId = (0, _react.useRef)(0);
  const {
    mutate: patchComment
  } = (0, _use_update_comment.useUpdateComment)();
  const {
    mutate: deleteComment
  } = (0, _use_delete_comment.useDeleteComment)();
  const [selectedOutlineCommentId, setSelectedOutlineCommentId] = (0, _react.useState)('');
  const [loadingCommentIds, setLoadingCommentIds] = (0, _react.useState)([]);
  const [manageMarkdownEditIds, setManageMarkdownEditIds] = (0, _react.useState)([]);
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  const commentRefs = (0, _react.useRef)({});
  const handleManageMarkdownEditId = (0, _react.useCallback)(id => {
    clearDraftComment();
    setManageMarkdownEditIds(prevManageMarkdownEditIds => !prevManageMarkdownEditIds.includes(id) ? prevManageMarkdownEditIds.concat(id) : prevManageMarkdownEditIds.filter(myId => id !== myId));
  }, [clearDraftComment]);
  const removeCommentIdFromLoadingIds = commentId => {
    setLoadingCommentIds(ids => ids.filter(loadingId => loadingId !== commentId));
  };
  const addCommentIdToLoadingIds = commentId => {
    setLoadingCommentIds(ids => [...ids, commentId]);
  };
  const handleSaveComment = (0, _react.useCallback)(({
    id,
    version
  }, content) => {
    addCommentIdToLoadingIds(id);
    patchComment({
      caseId,
      commentId: id,
      commentUpdate: content,
      version
    }, {
      onSuccess: () => {
        removeCommentIdFromLoadingIds(id);
      },
      onError: () => {
        removeCommentIdFromLoadingIds(id);
      }
    });
  }, [caseId, patchComment]);
  const handleDeleteComment = (0, _react.useCallback)((id, successToasterTitle) => {
    deleteComment({
      caseId,
      commentId: id,
      successToasterTitle
    });
  }, [caseId, deleteComment]);
  const handleOutlineComment = (0, _react.useCallback)(id => {
    const moveToTarget = document.getElementById(`${id}-permLink`);
    if (moveToTarget != null) {
      const yOffset = -120;
      const y = moveToTarget.getBoundingClientRect().top + window.pageYOffset + yOffset;
      window.scrollTo({
        top: y,
        behavior: 'smooth'
      });
      if (id === 'add-comment') {
        moveToTarget.getElementsByTagName('textarea')[0].focus();
      }
    }
    window.clearTimeout(handlerTimeoutId.current);
    setSelectedOutlineCommentId(id);
    handlerTimeoutId.current = window.setTimeout(() => {
      setSelectedOutlineCommentId('');
      window.clearTimeout(handlerTimeoutId.current);
    }, 2400);
  }, [handlerTimeoutId]);
  const handleManageQuote = (0, _react.useCallback)(quote => {
    const ref = commentRefs === null || commentRefs === void 0 ? void 0 : commentRefs.current[_constants.NEW_COMMENT_ID];
    if (isAddCommentRef(ref)) {
      ref.addQuote(quote);
    }
    handleOutlineComment('add-comment');
  }, [handleOutlineComment]);
  (0, _react.useEffect)(() => {
    if (draftComment !== null && draftComment !== void 0 && draftComment.commentId && (draftComment === null || draftComment === void 0 ? void 0 : draftComment.commentId) !== 'description') {
      var _commentRefs$current, _ref$editor;
      setManageMarkdownEditIds(prevManageMarkdownEditIds => {
        if (_constants.NEW_COMMENT_ID !== (draftComment === null || draftComment === void 0 ? void 0 : draftComment.commentId) && !prevManageMarkdownEditIds.includes(draftComment === null || draftComment === void 0 ? void 0 : draftComment.commentId)) {
          return [draftComment === null || draftComment === void 0 ? void 0 : draftComment.commentId];
        }
        return prevManageMarkdownEditIds;
      });
      const ref = commentRefs === null || commentRefs === void 0 ? void 0 : (_commentRefs$current = commentRefs.current) === null || _commentRefs$current === void 0 ? void 0 : _commentRefs$current[draftComment.commentId];
      if (isSetCommentRef(ref) && (_ref$editor = ref.editor) !== null && _ref$editor !== void 0 && _ref$editor.textarea) {
        ref.setComment(draftComment.comment);
        if (hasIncomingLensState) {
          openLensModal({
            editorRef: ref.editor
          });
        } else {
          clearDraftComment();
        }
      }
    }
  }, [clearDraftComment, draftComment, hasIncomingLensState, openLensModal]);
  return {
    loadingCommentIds,
    selectedOutlineCommentId,
    manageMarkdownEditIds,
    commentRefs,
    handleManageMarkdownEditId,
    handleOutlineComment,
    handleSaveComment,
    handleDeleteComment,
    handleManageQuote,
    handleUpdate: refreshCaseViewPage
  };
};
exports.useUserActionsHandler = useUserActionsHandler;