"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _markdown_link = require("./markdown_link");
var _use_plugins = require("./use_plugins");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/markdown_editor/renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const withDisabledLinks = disableLinks => {
  const MarkdownLinkProcessingComponent = /*#__PURE__*/(0, _react.memo)(props => /*#__PURE__*/_react.default.createElement(_markdown_link.MarkdownLink, (0, _extends2.default)({}, props, {
    disableLinks: disableLinks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  })));
  MarkdownLinkProcessingComponent.displayName = 'MarkdownLinkProcessingComponent';
  return MarkdownLinkProcessingComponent;
};
const MarkdownRendererComponent = ({
  children,
  disableLinks,
  textSize
}) => {
  const {
    processingPlugins,
    parsingPlugins
  } = (0, _use_plugins.usePlugins)();
  // Deep clone of the processing plugins to prevent affecting the markdown editor.
  const processingPluginList = (0, _fp.cloneDeep)(processingPlugins);
  // This line of code is TS-compatible and it will break if [1][1] change in the future.
  processingPluginList[1][1].components.a = (0, _react.useMemo)(() => withDisabledLinks(disableLinks), [disableLinks]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    parsingPluginList: parsingPlugins,
    processingPluginList: processingPluginList,
    grow: true,
    textSize: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, children);
};
MarkdownRendererComponent.displayName = 'MarkdownRenderer';
const MarkdownRenderer = exports.MarkdownRenderer = /*#__PURE__*/(0, _react.memo)(MarkdownRendererComponent);