"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _kibana = require("../../../common/lib/kibana");
var _use_get_fields = require("./use_get_fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _validate_json = require("../validate_json");
var _additional_form_fields = require("./additional_form_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/resilient/case_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResilientFieldsComponent = ({
  connector,
  isInSidebarForm
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isLoadingFields,
    isFetching: isFetchingFields,
    data: fieldsData
  } = (0, _use_get_fields.useGetFields)({
    http,
    connector
  });
  const allIncidentTypes = (0, _react.useMemo)(() => {
    var _fieldsData$data;
    const incidentTypesField = fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data = fieldsData.data) === null || _fieldsData$data === void 0 ? void 0 : _fieldsData$data.fieldsObj.incident_type_ids;
    if (incidentTypesField == null || !Array.isArray(incidentTypesField.values)) {
      return [];
    }
    return incidentTypesField.values.map(choice => ({
      id: choice.value.toString(),
      label: choice.label
    }));
  }, [fieldsData]);
  const severity = (0, _react.useMemo)(() => {
    var _fieldsData$data2;
    const severityField = fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data2 = fieldsData.data) === null || _fieldsData$data2 === void 0 ? void 0 : _fieldsData$data2.fieldsObj.severity_code;
    if (severityField == null || !Array.isArray(severityField.values)) {
      return [];
    }
    return severityField.values.map(choice => ({
      value: choice.value.toString(),
      text: choice.label
    }));
  }, [fieldsData]);
  const isLoading = isLoadingFields || isFetchingFields;
  const additionalFieldsProps = (0, _react.useMemo)(() => {
    return {
      componentProps: {
        connector,
        isInSidebarForm
      },
      config: {
        defaultValue: '',
        validations: [{
          validator: (0, _validate_json.generateJSONValidator)({
            maxAdditionalFields: 50
          })
        }]
      }
    };
  }, [connector, isInSidebarForm]);
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": 'connector-fields-resilient',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.incidentTypes",
    config: {
      defaultValue: []
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onChangeComboBox = changedOptions => {
      field.setValue(changedOptions.map(option => option.id));
    };
    const selectedOptions = field.value && allIncidentTypes !== null && allIncidentTypes !== void 0 && allIncidentTypes.length ? field.value.map(incidentType => {
      const matchedOption = allIncidentTypes.find(option => option.id === incidentType);
      return matchedOption !== null && matchedOption !== void 0 ? matchedOption : {
        label: incidentType,
        id: incidentType
      };
    }) : [];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "indexConnectorSelectSearchBox",
      fullWidth: true,
      label: i18n.INCIDENT_TYPES_LABEL,
      isInvalid: isInvalid,
      error: errorMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isInvalid,
      "data-test-subj": "incidentTypeComboBox",
      fullWidth: true,
      isClearable: true,
      isDisabled: isLoading,
      isLoading: isLoading,
      onChange: onChangeComboBox,
      options: allIncidentTypes,
      placeholder: i18n.INCIDENT_TYPES_PLACEHOLDER,
      selectedOptions: selectedOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 19
      }
    }));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.severityCode",
    component: _components.SelectField,
    config: {
      label: i18n.SEVERITY_LABEL
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'severitySelect',
        options: severity,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoading,
        isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.additionalFields",
    config: additionalFieldsProps.config,
    component: _additional_form_fields.AdditionalFormFields,
    componentProps: additionalFieldsProps.componentProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }));
};
exports.default = ResilientFieldsComponent;
ResilientFieldsComponent.displayName = 'ResilientFields';
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;