"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.templateFromReactComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _error_boundary = require("../components/enhance/error_boundary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/lib/template_from_react_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const templateFromReactComponent = Component => {
  const WrappedComponent = (props, ref) => {
    const [updatedProps, setUpdatedProps] = (0, _react.useState)(props);
    (0, _react.useImperativeHandle)(ref, () => ({
      updateProps: newProps => {
        setUpdatedProps(newProps);
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_error_boundary.ErrorBoundary, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 7
      }
    }, ({
      error
    }) => {
      if (error) {
        props.renderError();
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, updatedProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 15
        }
      })));
    });
  };
  const ForwardRefWrappedComponent = /*#__PURE__*/(0, _react.forwardRef)(WrappedComponent);
  ForwardRefWrappedComponent.propTypes = {
    // @ts-expect-error upgrade typescript v5.9.3
    renderError: _propTypes.default.func
  };
  return (domNode, config, handlers, onMount) => {
    try {
      const el = /*#__PURE__*/_react.default.createElement(ForwardRefWrappedComponent, (0, _extends2.default)({}, config, {
        ref: ref => {
          handlers.done();
          onMount === null || onMount === void 0 ? void 0 : onMount(ref);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 9
        }
      }));
      handlers.onDestroy(() => {
        (0, _reactDom.unmountComponentAtNode)(domNode);
      });
      return /*#__PURE__*/(0, _reactDom.createPortal)(el, domNode);
    } catch (err) {
      handlers.done();
      config.renderError();
    }
  };
};
exports.templateFromReactComponent = templateFromReactComponent;