"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeFilter = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18n = require("@kbn/i18n");
var _types = require("../../../../types");
var _utils = require("../utils");
var _default_filter = require("./default_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getFromLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.timeFilter.from', {
    defaultMessage: 'From'
  }),
  getToLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.timeFilter.to', {
    defaultMessage: 'To'
  }),
  getInvalidDateLabel: date => _i18n.i18n.translate('xpack.canvas.workpadFilters.timeFilter.invalidDate', {
    defaultMessage: 'Invalid date: {date}',
    values: {
      date
    }
  })
};
const {
  column,
  type,
  filterGroup
} = _default_filter.defaultFilter.view;
const formatTime = (str, roundUp) => {
  const moment = _datemath.default.parse(str, {
    roundUp
  });
  if (!moment || !moment.isValid()) {
    return strings.getInvalidDateLabel(str);
  }
  return moment.format('YYYY-MM-DD HH:mm:ss');
};
const timeFilter = exports.timeFilter = {
  name: _types.FilterType.time,
  view: {
    column,
    value: ({
      to,
      from
    }) => ({
      from: {
        label: strings.getFromLabel(),
        formatter: () => formatTime(from, false)
      },
      to: {
        label: strings.getToLabel(),
        formatter: () => formatTime(to, true)
      }
    }),
    type: {
      label: type.label,
      formatter: (0, _utils.formatByKey)('type')
    },
    filterGroup
  }
};