"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndexAdapter = exports.automaticImportSamplesIndexName = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const automaticImportSamplesIndexName = exports.automaticImportSamplesIndexName = 'automatic-import-samples';
const automaticImportSamplesIndexAdapterSettings = {
  name: automaticImportSamplesIndexName,
  schema: {
    properties: {
      // ONLY map fields we actively search/filter/aggregate on
      integration_id: _storageAdapter.types.keyword({
        ignore_above: 256
      }),
      data_stream_id: _storageAdapter.types.keyword({
        ignore_above: 256
      }),
      created_by: _storageAdapter.types.keyword({
        ignore_above: 256
      }),
      // We can filter by this
      original_source: _storageAdapter.types.object({
        properties: {
          source_type: _storageAdapter.types.keyword({
            ignore_above: 256
          }),
          source_value: _storageAdapter.types.keyword({
            ignore_above: 256
          })
        }
      }),
      // Non-searchable fields (stored but not indexed)
      log_data: _storageAdapter.types.text({
        index: false
      }),
      // Log samples are stored but not indexed
      metadata: _storageAdapter.types.object({
        properties: {
          created_at: _storageAdapter.types.date({
            index: false
          })
        }
      })
    }
  }
};
const createIndexAdapter = ({
  logger,
  esClient
}) => {
  return new _storageAdapter.StorageIndexAdapter(esClient, logger, automaticImportSamplesIndexAdapterSettings);
};
exports.createIndexAdapter = createIndexAdapter;