"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ECS_FULL = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ECS_FULL = exports.ECS_FULL = {
  '@timestamp': 'Date/time when the event originated.',
  'agent.build.original': 'Extended build information for the agent.',
  'agent.ephemeral_id': 'Ephemeral identifier of this agent.',
  'agent.id': 'Unique identifier of this agent.',
  'agent.name': 'Custom name of the agent.',
  'agent.type': 'Type of the agent.',
  'agent.version': 'Version of the agent.',
  'client.address': 'Client network address.',
  'client.as.number': 'Unique number allocated to the autonomous system.',
  'client.as.organization.name': 'Organization name.',
  'client.bytes': 'Bytes sent from the client to the server.',
  'client.domain': 'The domain name of the client.',
  'client.geo.city_name': 'City name.',
  'client.geo.continent_code': 'Continent code.',
  'client.geo.continent_name': 'Name of the continent.',
  'client.geo.country_iso_code': 'Country ISO code.',
  'client.geo.country_name': 'Country name.',
  'client.geo.location': 'Longitude and latitude.',
  'client.geo.name': 'User-defined description of a location.',
  'client.geo.postal_code': 'Postal code.',
  'client.geo.region_iso_code': 'Region ISO code.',
  'client.geo.region_name': 'Region name.',
  'client.geo.timezone': 'Time zone.',
  'client.ip': 'IP address of the client.',
  'client.mac': 'MAC address of the client.',
  'client.nat.ip': 'Client NAT ip address',
  'client.nat.port': 'Client NAT port',
  'client.packets': 'Packets sent from the client to the server.',
  'client.port': 'Port of the client.',
  'client.registered_domain': 'The highest registered client domain, stripped of the subdomain.',
  'client.subdomain': 'The subdomain of the domain.',
  'client.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'client.user.domain': 'Name of the directory the user is a member of.',
  'client.user.email': 'User email address.',
  'client.user.full_name': 'Users full name, if available.',
  'client.user.group.domain': 'Name of the directory the group is a member of.',
  'client.user.group.id': 'Unique identifier for the group on the system/platform.',
  'client.user.group.name': 'Name of the group.',
  'client.user.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'client.user.id': 'Unique identifier of the user.',
  'client.user.name': 'Short name or login of the user.',
  'client.user.roles': 'Array of user roles at the time of the event.',
  'cloud.account.id': 'The cloud account or organization id.',
  'cloud.account.name': 'The cloud account name.',
  'cloud.availability_zone': 'Availability zone in which this host, resource, or service is located.',
  'cloud.instance.id': 'Instance ID of the host machine.',
  'cloud.instance.name': 'Instance name of the host machine.',
  'cloud.machine.type': 'Machine type of the host machine.',
  'cloud.origin.account.id': 'The cloud account or organization id.',
  'cloud.origin.account.name': 'The cloud account name.',
  'cloud.origin.availability_zone': 'Availability zone in which this host, resource, or service is located.',
  'cloud.origin.instance.id': 'Instance ID of the host machine.',
  'cloud.origin.instance.name': 'Instance name of the host machine.',
  'cloud.origin.machine.type': 'Machine type of the host machine.',
  'cloud.origin.project.id': 'The cloud project id.',
  'cloud.origin.project.name': 'The cloud project name.',
  'cloud.origin.provider': 'Name of the cloud provider.',
  'cloud.origin.region': 'Region in which this host, resource, or service is located.',
  'cloud.origin.service.name': 'The cloud service name.',
  'cloud.project.id': 'The cloud project id.',
  'cloud.project.name': 'The cloud project name.',
  'cloud.provider': 'Name of the cloud provider.',
  'cloud.region': 'Region in which this host, resource, or service is located.',
  'cloud.service.name': 'The cloud service name.',
  'cloud.target.account.id': 'The cloud account or organization id.',
  'cloud.target.account.name': 'The cloud account name.',
  'cloud.target.availability_zone': 'Availability zone in which this host, resource, or service is located.',
  'cloud.target.instance.id': 'Instance ID of the host machine.',
  'cloud.target.instance.name': 'Instance name of the host machine.',
  'cloud.target.machine.type': 'Machine type of the host machine.',
  'cloud.target.project.id': 'The cloud project id.',
  'cloud.target.project.name': 'The cloud project name.',
  'cloud.target.provider': 'Name of the cloud provider.',
  'cloud.target.region': 'Region in which this host, resource, or service is located.',
  'cloud.target.service.name': 'The cloud service name.',
  'container.cpu.usage': 'Percent CPU used, between 0 and 1.',
  'container.disk.read.bytes': 'The number of bytes read by all disks.',
  'container.disk.write.bytes': 'The number of bytes written on all disks.',
  'container.id': 'Unique container id.',
  'container.image.hash.all': 'An array of digests of the image the container was built on.',
  'container.image.name': 'Name of the image the container was built on.',
  'container.image.tag': 'Container image tags.',
  'container.labels': 'Image labels.',
  'container.memory.usage': 'Percent memory used, between 0 and 1.',
  'container.name': 'Container name.',
  'container.network.egress.bytes': 'The number of bytes sent on all network interfaces.',
  'container.network.ingress.bytes': 'The number of bytes received on all network interfaces.',
  'container.runtime': 'Runtime managing this container.',
  'container.security_context.privileged': 'Indicates whether the container is running in privileged mode.',
  'data_stream.dataset': 'The field can contain anything that makes sense to signify the source of the data.',
  'data_stream.namespace': 'A user defined namespace. Namespaces are useful to allow grouping of data.',
  'data_stream.type': 'An overarching type for the data stream.',
  'destination.address': 'Destination network address.',
  'destination.as.number': 'Unique number allocated to the autonomous system.',
  'destination.as.organization.name': 'Organization name.',
  'destination.bytes': 'Bytes sent from the destination to the source.',
  'destination.domain': 'The domain name of the destination.',
  'destination.geo.city_name': 'City name.',
  'destination.geo.continent_code': 'Continent code.',
  'destination.geo.continent_name': 'Name of the continent.',
  'destination.geo.country_iso_code': 'Country ISO code.',
  'destination.geo.country_name': 'Country name.',
  'destination.geo.location': 'Longitude and latitude.',
  'destination.geo.name': 'User-defined description of a location.',
  'destination.geo.postal_code': 'Postal code.',
  'destination.geo.region_iso_code': 'Region ISO code.',
  'destination.geo.region_name': 'Region name.',
  'destination.geo.timezone': 'Time zone.',
  'destination.ip': 'IP address of the destination.',
  'destination.mac': 'MAC address of the destination.',
  'destination.nat.ip': 'Destination NAT ip',
  'destination.nat.port': 'Destination NAT Port',
  'destination.packets': 'Packets sent from the destination to the source.',
  'destination.port': 'Port of the destination.',
  'destination.registered_domain': 'The highest registered destination domain, stripped of the subdomain.',
  'destination.subdomain': 'The subdomain of the domain.',
  'destination.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'destination.user.domain': 'Name of the directory the user is a member of.',
  'destination.user.email': 'User email address.',
  'destination.user.full_name': 'Users full name, if available.',
  'destination.user.group.domain': 'Name of the directory the group is a member of.',
  'destination.user.group.id': 'Unique identifier for the group on the system/platform.',
  'destination.user.group.name': 'Name of the group.',
  'destination.user.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'destination.user.id': 'Unique identifier of the user.',
  'destination.user.name': 'Short name or login of the user.',
  'destination.user.roles': 'Array of user roles at the time of the event.',
  'device.id': 'The unique identifier of a device.',
  'device.manufacturer': 'The vendor name of the device manufacturer.',
  'device.model.identifier': 'The machine readable identifier of the device model.',
  'device.model.name': 'The human readable marketing name of the device model.',
  'dll.code_signature.digest_algorithm': 'Hashing algorithm used to sign the process.',
  'dll.code_signature.exists': 'Boolean to capture if a signature is present.',
  'dll.code_signature.signing_id': 'The identifier used to sign the process.',
  'dll.code_signature.status': 'Additional information about the certificate status.',
  'dll.code_signature.subject_name': 'Subject name of the code signer',
  'dll.code_signature.team_id': 'The team identifier used to sign the process.',
  'dll.code_signature.timestamp': 'When the signature was generated and signed.',
  'dll.code_signature.trusted': 'Stores the trust status of the certificate chain.',
  'dll.code_signature.valid': 'Boolean to capture if the digital signature is verified against the binary content.',
  'dll.hash.md5': 'MD5 hash.',
  'dll.hash.sha1': 'SHA1 hash.',
  'dll.hash.sha256': 'SHA256 hash.',
  'dll.hash.sha384': 'SHA384 hash.',
  'dll.hash.sha512': 'SHA512 hash.',
  'dll.hash.ssdeep': 'SSDEEP hash.',
  'dll.hash.tlsh': 'TLSH hash.',
  'dll.name': 'Name of the library.',
  'dll.path': 'Full file path of the library.',
  'dll.pe.architecture': 'CPU architecture target for the file.',
  'dll.pe.company': 'Internal company name of the file, provided at compile-time.',
  'dll.pe.description': 'Internal description of the file, provided at compile-time.',
  'dll.pe.file_version': 'Process name.',
  'dll.pe.go_import_hash': 'A hash of the Go language imports in a PE file.',
  'dll.pe.go_imports': 'List of imported Go language element names and types.',
  'dll.pe.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'dll.pe.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'dll.pe.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'dll.pe.imphash': 'A hash of the imports in a PE file.',
  'dll.pe.import_hash': 'A hash of the imports in a PE file.',
  'dll.pe.imports': 'List of imported element names and types.',
  'dll.pe.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'dll.pe.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'dll.pe.original_file_name': 'Internal name of the file, provided at compile-time.',
  'dll.pe.pehash': 'A hash of the PE header and data from one or more PE sections.',
  'dll.pe.product': 'Internal product name of the file, provided at compile-time.',
  'dll.pe.sections': 'Section information of the PE file.',
  'dll.pe.sections.entropy': 'Shannon entropy calculation from the section.',
  'dll.pe.sections.name': 'PE Section List name.',
  'dll.pe.sections.physical_size': 'PE Section List physical size.',
  'dll.pe.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'dll.pe.sections.virtual_size': 'PE Section List virtual size. This is always the same as `physical_size`.',
  'dns.answers': 'Array of DNS answers.',
  'dns.answers.class': 'The class of DNS data contained in this resource record.',
  'dns.answers.data': 'The data describing the resource.',
  'dns.answers.name': 'The domain name to which this resource record pertains.',
  'dns.answers.ttl': 'The time interval in seconds that this resource record may be cached before it should be discarded.',
  'dns.answers.type': 'The type of data contained in this resource record.',
  'dns.header_flags': 'Array of DNS header flags.',
  'dns.id': 'The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.',
  'dns.op_code': 'The DNS operation code that specifies the kind of query in the message.',
  'dns.question.class': 'The class of records being queried.',
  'dns.question.name': 'The name being queried.',
  'dns.question.registered_domain': 'The highest registered domain, stripped of the subdomain.',
  'dns.question.subdomain': 'The subdomain of the domain.',
  'dns.question.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'dns.question.type': 'The type of record being queried.',
  'dns.resolved_ip': 'Array containing all IPs seen in answers.data',
  'dns.response_code': 'The DNS response code.',
  'dns.type': 'The type of DNS event captured, query or answer.',
  'ecs.version': 'ECS version this event conforms to.',
  'email.attachments': 'List of objects describing the attachments.',
  'email.attachments.file.extension': 'Attachment file extension.',
  'email.attachments.file.hash.md5': 'MD5 hash.',
  'email.attachments.file.hash.sha1': 'SHA1 hash.',
  'email.attachments.file.hash.sha256': 'SHA256 hash.',
  'email.attachments.file.hash.sha384': 'SHA384 hash.',
  'email.attachments.file.hash.sha512': 'SHA512 hash.',
  'email.attachments.file.hash.ssdeep': 'SSDEEP hash.',
  'email.attachments.file.hash.tlsh': 'TLSH hash.',
  'email.attachments.file.mime_type': 'MIME type of the attachment file.',
  'email.attachments.file.name': 'Name of the attachment file.',
  'email.attachments.file.size': 'Attachment file size.',
  'email.bcc.address': 'Email address of BCC recipient',
  'email.cc.address': 'Email address of CC recipient',
  'email.content_type': 'MIME type of the email message.',
  'email.delivery_timestamp': 'Date and time when message was delivered.',
  'email.direction': 'Direction of the message.',
  'email.from.address': 'The senders email address.',
  'email.local_id': 'Unique identifier given by the source.',
  'email.message_id': 'Value from the Message-ID header.',
  'email.origination_timestamp': 'Date and time the email was composed.',
  'email.reply_to.address': 'Address replies should be delivered to.',
  'email.sender.address': 'Address of the message sender.',
  'email.subject': 'The subject of the email message.',
  'email.to.address': 'Email address of recipient',
  'email.x_mailer': 'Application that drafted email.',
  'error.code': 'Error code describing the error.',
  'error.id': 'Unique identifier for the error.',
  'error.message': 'Error message.',
  'error.stack_trace': 'The stack trace of this error in plain text.',
  'error.type': 'The type of the error, for example the class name of the exception.',
  'event.action': 'The action captured by the event.',
  'event.agent_id_status': 'Validation status of the events agent.id field.',
  'event.category': 'Event category. The second categorization field in the hierarchy.',
  'event.code': 'Identification code for this event.',
  'event.created': 'Time when the event was first read by an agent or by your pipeline.',
  'event.dataset': 'Name of the dataset.',
  'event.duration': 'Duration of the event in nanoseconds.',
  'event.end': '`event.end` contains the date when the event ended or when the activity was last observed.',
  'event.hash': 'Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity.',
  'event.id': 'Unique ID to describe the event.',
  'event.ingested': 'Timestamp when an event arrived in the central data store.',
  'event.kind': 'The kind of the event. The highest categorization field in the hierarchy.',
  'event.module': 'Name of the module this data is coming from.',
  'event.original': 'Raw text message of entire event.',
  'event.outcome': 'The outcome of the event. The lowest level categorization field in the hierarchy.',
  'event.provider': 'Source of the event.',
  'event.reason': 'Reason why this event happened, according to the source',
  'event.reference': 'Event reference URL',
  'event.risk_score': 'Risk score or priority of the event (e.g. security solutions). Use your systems original value here.',
  'event.risk_score_norm': 'Normalized risk score or priority of the event (0-100).',
  'event.sequence': 'Sequence number of the event.',
  'event.severity': 'Numeric severity of the event.',
  'event.start': '`event.start` contains the date when the event started or when the activity was first observed.',
  'event.timezone': 'Event time zone.',
  'event.type': 'Event type. The third categorization field in the hierarchy.',
  'event.url': 'Event investigation URL',
  'faas.coldstart': 'Boolean value indicating a cold start of a function.',
  'faas.execution': 'The execution ID of the current function execution.',
  'faas.id': 'The unique identifier of a serverless function.',
  'faas.name': 'The name of a serverless function.',
  'faas.trigger.request_id': 'The ID of the trigger request , message, event, etc.',
  'faas.trigger.type': 'The trigger for the function execution.',
  'faas.version': 'The version of a serverless function.',
  'file.accessed': 'Last time the file was accessed.',
  'file.attributes': 'Array of file attributes.',
  'file.code_signature.digest_algorithm': 'Hashing algorithm used to sign the process.',
  'file.code_signature.exists': 'Boolean to capture if a signature is present.',
  'file.code_signature.signing_id': 'The identifier used to sign the process.',
  'file.code_signature.status': 'Additional information about the certificate status.',
  'file.code_signature.subject_name': 'Subject name of the code signer',
  'file.code_signature.team_id': 'The team identifier used to sign the process.',
  'file.code_signature.timestamp': 'When the signature was generated and signed.',
  'file.code_signature.trusted': 'Stores the trust status of the certificate chain.',
  'file.code_signature.valid': 'Boolean to capture if the digital signature is verified against the binary content.',
  'file.created': 'File creation time.',
  'file.ctime': 'Last time the file attributes or metadata changed.',
  'file.device': 'Device that is the source of the file.',
  'file.directory': 'Directory where the file is located.',
  'file.drive_letter': 'Drive letter where the file is located.',
  'file.elf.architecture': 'Machine architecture of the ELF file.',
  'file.elf.byte_order': 'Byte sequence of ELF file.',
  'file.elf.cpu_type': 'CPU type of the ELF file.',
  'file.elf.creation_date': 'Build or compile date.',
  'file.elf.exports': 'List of exported element names and types.',
  'file.elf.go_import_hash': 'A hash of the Go language imports in an ELF file.',
  'file.elf.go_imports': 'List of imported Go language element names and types.',
  'file.elf.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'file.elf.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'file.elf.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'file.elf.header.abi_version': 'Version of the ELF Application Binary Interface (ABI).',
  'file.elf.header.class': 'Header class of the ELF file.',
  'file.elf.header.data': 'Data table of the ELF header.',
  'file.elf.header.entrypoint': 'Header entrypoint of the ELF file.',
  'file.elf.header.object_version': '"0x1" for original ELF files.',
  'file.elf.header.os_abi': 'Application Binary Interface (ABI) of the Linux OS.',
  'file.elf.header.type': 'Header type of the ELF file.',
  'file.elf.header.version': 'Version of the ELF header.',
  'file.elf.import_hash': 'A hash of the imports in an ELF file.',
  'file.elf.imports': 'List of imported element names and types.',
  'file.elf.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'file.elf.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'file.elf.sections': 'Section information of the ELF file.',
  'file.elf.sections.chi2': 'Chi-square probability distribution of the section.',
  'file.elf.sections.entropy': 'Shannon entropy calculation from the section.',
  'file.elf.sections.flags': 'ELF Section List flags.',
  'file.elf.sections.name': 'ELF Section List name.',
  'file.elf.sections.physical_offset': 'ELF Section List offset.',
  'file.elf.sections.physical_size': 'ELF Section List physical size.',
  'file.elf.sections.type': 'ELF Section List type.',
  'file.elf.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'file.elf.sections.virtual_address': 'ELF Section List virtual address.',
  'file.elf.sections.virtual_size': 'ELF Section List virtual size.',
  'file.elf.segments': 'ELF object segment list.',
  'file.elf.segments.sections': 'ELF object segment sections.',
  'file.elf.segments.type': 'ELF object segment type.',
  'file.elf.shared_libraries': 'List of shared libraries used by this ELF object.',
  'file.elf.telfhash': 'telfhash hash for ELF file.',
  'file.extension': 'File extension, excluding the leading dot.',
  'file.fork_name': 'A fork is additional data associated with a filesystem object.',
  'file.gid': 'Primary group ID (GID) of the file.',
  'file.group': 'Primary group name of the file.',
  'file.hash.md5': 'MD5 hash.',
  'file.hash.sha1': 'SHA1 hash.',
  'file.hash.sha256': 'SHA256 hash.',
  'file.hash.sha384': 'SHA384 hash.',
  'file.hash.sha512': 'SHA512 hash.',
  'file.hash.ssdeep': 'SSDEEP hash.',
  'file.hash.tlsh': 'TLSH hash.',
  'file.inode': 'Inode representing the file in the filesystem.',
  'file.macho.go_import_hash': 'A hash of the Go language imports in a Mach-O file.',
  'file.macho.go_imports': 'List of imported Go language element names and types.',
  'file.macho.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'file.macho.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'file.macho.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'file.macho.import_hash': 'A hash of the imports in a Mach-O file.',
  'file.macho.imports': 'List of imported element names and types.',
  'file.macho.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'file.macho.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'file.macho.sections': 'Section information of the Mach-O file.',
  'file.macho.sections.entropy': 'Shannon entropy calculation from the section.',
  'file.macho.sections.name': 'Mach-O Section List name.',
  'file.macho.sections.physical_size': 'Mach-O Section List physical size.',
  'file.macho.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'file.macho.sections.virtual_size': 'Mach-O Section List virtual size. This is always the same as `physical_size`.',
  'file.macho.symhash': 'A hash of the imports in a Mach-O file.',
  'file.mime_type': 'Media type of file, document, or arrangement of bytes.',
  'file.mode': 'Mode of the file in octal representation.',
  'file.mtime': 'Last time the file content was modified.',
  'file.name': 'Name of the file including the extension, without the directory.',
  'file.owner': 'File owners username.',
  'file.path': 'Full path to the file, including the file name.',
  'file.pe.architecture': 'CPU architecture target for the file.',
  'file.pe.company': 'Internal company name of the file, provided at compile-time.',
  'file.pe.description': 'Internal description of the file, provided at compile-time.',
  'file.pe.file_version': 'Process name.',
  'file.pe.go_import_hash': 'A hash of the Go language imports in a PE file.',
  'file.pe.go_imports': 'List of imported Go language element names and types.',
  'file.pe.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'file.pe.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'file.pe.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'file.pe.imphash': 'A hash of the imports in a PE file.',
  'file.pe.import_hash': 'A hash of the imports in a PE file.',
  'file.pe.imports': 'List of imported element names and types.',
  'file.pe.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'file.pe.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'file.pe.original_file_name': 'Internal name of the file, provided at compile-time.',
  'file.pe.pehash': 'A hash of the PE header and data from one or more PE sections.',
  'file.pe.product': 'Internal product name of the file, provided at compile-time.',
  'file.pe.sections': 'Section information of the PE file.',
  'file.pe.sections.entropy': 'Shannon entropy calculation from the section.',
  'file.pe.sections.name': 'PE Section List name.',
  'file.pe.sections.physical_size': 'PE Section List physical size.',
  'file.pe.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'file.pe.sections.virtual_size': 'PE Section List virtual size. This is always the same as `physical_size`.',
  'file.size': 'File size in bytes.',
  'file.target_path': 'Target path for symlinks.',
  'file.type': 'File type (file, dir, or symlink).',
  'file.uid': 'The user ID (UID) or security identifier (SID) of the file owner.',
  'file.x509.alternative_names': 'List of subject alternative names (SAN).',
  'file.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'file.x509.issuer.country': 'List of country (C) codes',
  'file.x509.issuer.distinguished_name': 'Distinguished name (DN) of issuing certificate authority.',
  'file.x509.issuer.locality': 'List of locality names (L)',
  'file.x509.issuer.organization': 'List of organizations (O) of issuing certificate authority.',
  'file.x509.issuer.organizational_unit': 'List of organizational units (OU) of issuing certificate authority.',
  'file.x509.issuer.state_or_province': 'List of state or province names (ST, S, or P)',
  'file.x509.not_after': 'Time at which the certificate is no longer considered valid.',
  'file.x509.not_before': 'Time at which the certificate is first considered valid.',
  'file.x509.public_key_algorithm': 'Algorithm used to generate the public key.',
  'file.x509.public_key_curve': 'The curve used by the elliptic curve public key algorithm. This is algorithm specific',
  'file.x509.public_key_exponent': 'Exponent used to derive the public key. This is algorithm   specific',
  'file.x509.public_key_size': 'The size of the public key space in bits.',
  'file.x509.serial_number': 'Unique serial number issued by the certificate authority.',
  'file.x509.signature_algorithm': 'Identifier for certificate signature algorithm.',
  'file.x509.subject.common_name': 'List of common names (CN) of subject.',
  'file.x509.subject.country': 'List of country (C) code',
  'file.x509.subject.distinguished_name': 'Distinguished name (DN) of the certificate subject   entity',
  'file.x509.subject.locality': 'List of locality names (L)',
  'file.x509.subject.organization': 'List of organizations (O) of subject.',
  'file.x509.subject.organizational_unit': 'List of organizational units (OU) of subject.',
  'file.x509.subject.state_or_province': 'List of state or province names (ST, S, or P)',
  'file.x509.version_number': 'Version of x509 format.',
  'group.domain': 'Name of the directory the group is a member of.',
  'group.id': 'Unique identifier for the group on the system/platform.',
  'group.name': 'Name of the group.',
  'host.architecture': 'Operating system architecture.',
  'host.boot.id': 'Linux boot uuid taken from /proc/sys/kernel/random/boot_id',
  'host.cpu.usage': 'Percent CPU used, between 0 and 1.',
  'host.disk.read.bytes': 'The number of bytes read by all disks.',
  'host.disk.write.bytes': 'The number of bytes written on all disks.',
  'host.domain': 'Name of the directory the group is a member of.',
  'host.geo.city_name': 'City name.',
  'host.geo.continent_code': 'Continent code.',
  'host.geo.continent_name': 'Name of the continent.',
  'host.geo.country_iso_code': 'Country ISO code.',
  'host.geo.country_name': 'Country name.',
  'host.geo.location': 'Longitude and latitude.',
  'host.geo.name': 'User-defined description of a location.',
  'host.geo.postal_code': 'Postal code.',
  'host.geo.region_iso_code': 'Region ISO code.',
  'host.geo.region_name': 'Region name.',
  'host.geo.timezone': 'Time zone.',
  'host.hostname': 'Hostname of the host.',
  'host.id': 'Unique host id.',
  'host.ip': 'Host ip addresses.',
  'host.mac': 'Host MAC addresses.',
  'host.name': 'Name of the host.',
  'host.network.egress.bytes': 'The number of bytes sent on all network interfaces.',
  'host.network.egress.packets': 'The number of packets sent on all network interfaces.',
  'host.network.ingress.bytes': 'The number of bytes received on all network interfaces.',
  'host.network.ingress.packets': 'The number of packets received on all network interfaces.',
  'host.os.family': 'OS family (such as redhat, debian, freebsd, windows).',
  'host.os.full': 'Operating system name, including the version or code name.',
  'host.os.kernel': 'Operating system kernel version as a raw string.',
  'host.os.name': 'Operating system name, without the version.',
  'host.os.platform': 'Operating system platform (such centos, ubuntu, windows).',
  'host.os.type': 'Which commercial OS family (one of: linux, macos, unix, windows, ios   or android).',
  'host.os.version': 'Operating system version as a raw string.',
  'host.pid_ns_ino': 'Pid namespace inode',
  'host.risk.calculated_level': 'A risk classification level calculated by an internal   system as part of entity analytics and entity risk scoring',
  'host.risk.calculated_score': 'A risk classification score calculated by an internal   system as part of entity analytics and entity risk scoring',
  'host.risk.calculated_score_norm': 'A normalized risk score calculated by an internal   system',
  'host.risk.static_level': 'A risk classification level obtained from outside the system,   such as from some external Threat Intelligence Platform',
  'host.risk.static_score': 'A risk classification score obtained from outside the system,   such as from some external Threat Intelligence Platform',
  'host.risk.static_score_norm': 'A normalized risk score calculated by an external system.',
  'host.type': 'Type of host.',
  'host.uptime': 'Seconds the host has been up.',
  'http.request.body.bytes': 'Size in bytes of the request body.',
  'http.request.body.content': 'The full HTTP request body.',
  'http.request.bytes': 'Total size in bytes of the request (body and headers).',
  'http.request.id': 'HTTP request ID.',
  'http.request.method': 'HTTP request method.',
  'http.request.mime_type': 'Mime type of the body of the request.',
  'http.request.referrer': 'Referrer for this HTTP request.',
  'http.response.body.bytes': 'Size in bytes of the response body.',
  'http.response.body.content': 'The full HTTP response body.',
  'http.response.bytes': 'Total size in bytes of the response (body and headers).',
  'http.response.mime_type': 'Mime type of the body of the response.',
  'http.response.status_code': 'HTTP response status code.',
  'http.version': 'HTTP version.',
  labels: 'Custom key/value pairs.',
  'log.file.path': 'Full path to the log file this event came from.',
  'log.level': 'Log level of the log event.',
  'log.logger': 'Name of the logger.',
  'log.origin.file.line': 'The line number of the file which originated the log event.',
  'log.origin.file.name': 'The code file which originated the log event.',
  'log.origin.function': 'The function which originated the log event.',
  'log.syslog': 'Syslog metadata',
  'log.syslog.appname': 'The device or application that originated the Syslog message.',
  'log.syslog.facility.code': 'Syslog numeric facility of the event.',
  'log.syslog.facility.name': 'Syslog text-based facility of the event.',
  'log.syslog.hostname': 'The host that originated the Syslog message.',
  'log.syslog.msgid': 'An identifier for the type of Syslog message.',
  'log.syslog.priority': 'Syslog priority of the event.',
  'log.syslog.procid': 'The process name or ID that originated the Syslog message.',
  'log.syslog.severity.code': 'Syslog numeric severity of the event.',
  'log.syslog.severity.name': 'Syslog text-based severity of the event.',
  'log.syslog.structured_data': 'Structured data expressed in RFC 5424 messages.',
  'log.syslog.version': 'Syslog protocol version.',
  message: 'Log message optimized for viewing in a log viewer.',
  'network.application': 'Application level protocol name.',
  'network.bytes': 'Total bytes transferred in both directions.',
  'network.community_id': 'A hash of source and destination IPs and ports.',
  'network.direction': 'Direction of the network traffic.',
  'network.forwarded_ip': 'Host IP address when the source IP address is the proxy.',
  'network.iana_number': 'IANA Protocol Number.',
  'network.inner': 'Inner VLAN tag information',
  'network.inner.vlan.id': 'VLAN ID as reported by the observer.',
  'network.inner.vlan.name': 'Optional VLAN name as reported by the observer.',
  'network.name': 'Name given by operators to sections of their network.',
  'network.packets': 'Total packets transferred in both directions.',
  'network.protocol': 'Application protocol name.',
  'network.transport': 'Protocol Name corresponding to the field `iana_number`.',
  'network.type': 'In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc',
  'network.vlan.id': 'VLAN ID as reported by the observer.',
  'network.vlan.name': 'Optional VLAN name as reported by the observer.',
  'observer.egress': 'Object field for egress information',
  'observer.egress.interface.alias': 'Interface alias',
  'observer.egress.interface.id': 'Interface ID',
  'observer.egress.interface.name': 'Interface name',
  'observer.egress.vlan.id': 'VLAN ID as reported by the observer.',
  'observer.egress.vlan.name': 'Optional VLAN name as reported by the observer.',
  'observer.egress.zone': 'Observer Egress zone',
  'observer.geo.city_name': 'City name.',
  'observer.geo.continent_code': 'Continent code.',
  'observer.geo.continent_name': 'Name of the continent.',
  'observer.geo.country_iso_code': 'Country ISO code.',
  'observer.geo.country_name': 'Country name.',
  'observer.geo.location': 'Longitude and latitude.',
  'observer.geo.name': 'User-defined description of a location.',
  'observer.geo.postal_code': 'Postal code.',
  'observer.geo.region_iso_code': 'Region ISO code.',
  'observer.geo.region_name': 'Region name.',
  'observer.geo.timezone': 'Time zone.',
  'observer.hostname': 'Hostname of the observer.',
  'observer.ingress': 'Object field for ingress information',
  'observer.ingress.interface.alias': 'Interface alias',
  'observer.ingress.interface.id': 'Interface ID',
  'observer.ingress.interface.name': 'Interface name',
  'observer.ingress.vlan.id': 'VLAN ID as reported by the observer.',
  'observer.ingress.vlan.name': 'Optional VLAN name as reported by the observer.',
  'observer.ingress.zone': 'Observer ingress zone',
  'observer.ip': 'IP addresses of the observer.',
  'observer.mac': 'MAC addresses of the observer.',
  'observer.name': 'Custom name of the observer.',
  'observer.os.family': 'OS family (such as redhat, debian, freebsd, windows).',
  'observer.os.full': 'Operating system name, including the version or code name.',
  'observer.os.kernel': 'Operating system kernel version as a raw string.',
  'observer.os.name': 'Operating system name, without the version.',
  'observer.os.platform': 'Operating system platform (such centos, ubuntu, windows).',
  'observer.os.type': 'Which commercial OS family (one of: linux, macos, unix, windows, ios or android).',
  'observer.os.version': 'Operating system version as a raw string.',
  'observer.product': 'The product name of the observer.',
  'observer.serial_number': 'Observer serial number.',
  'observer.type': 'The type of the observer the data is coming from.',
  'observer.vendor': 'Vendor name of the observer.',
  'observer.version': 'Observer version.',
  'orchestrator.api_version': 'API version being used to carry out the action',
  'orchestrator.cluster.id': 'Unique ID of the cluster.',
  'orchestrator.cluster.name': 'Name of the cluster.',
  'orchestrator.cluster.url': 'URL of the API used to manage the cluster.',
  'orchestrator.cluster.version': 'The version of the cluster.',
  'orchestrator.namespace': 'Namespace in which the action is taking place.',
  'orchestrator.organization': 'Organization affected by the event (for multi-tenant orchestrator setups).',
  'orchestrator.resource.annotation': 'The list of annotations added to the resource.',
  'orchestrator.resource.id': 'Unique ID of the resource being acted upon.',
  'orchestrator.resource.ip': 'IP address assigned to the resource associated with the event being observed.',
  'orchestrator.resource.label': 'The list of labels added to the resource.',
  'orchestrator.resource.name': 'Name of the resource being acted upon.',
  'orchestrator.resource.parent.type': 'Type or kind of the parent resource associated with the event being observed.',
  'orchestrator.resource.type': 'Type of resource being acted upon.',
  'orchestrator.type': 'Orchestrator cluster type (e.g. kubernetes, nomad or cloudfoundry).',
  'organization.id': 'Unique identifier for the organization.',
  'organization.name': 'Organization name.',
  'package.architecture': 'Package architecture.',
  'package.build_version': 'Build version information',
  'package.checksum': 'Checksum of the installed package for verification.',
  'package.description': 'Description of the package.',
  'package.install_scope': 'Indicating how the package was installed, e.g. user-local, global.',
  'package.installed': 'Time when package was installed.',
  'package.license': 'Package license',
  'package.name': 'Package name',
  'package.path': 'Path where the package is installed.',
  'package.reference': 'Package home page or reference URL',
  'package.size': 'Package size in bytes.',
  'package.type': 'Package type',
  'package.version': 'Package version',
  'process.args': 'Array of process arguments.',
  'process.args_count': 'Length of the process.args array.',
  'process.code_signature.digest_algorithm': 'Hashing algorithm used to sign the process.',
  'process.code_signature.exists': 'Boolean to capture if a signature is present.',
  'process.code_signature.signing_id': 'The identifier used to sign the process.',
  'process.code_signature.status': 'Additional information about the certificate status.',
  'process.code_signature.subject_name': 'Subject name of the code signer',
  'process.code_signature.team_id': 'The team identifier used to sign the process.',
  'process.code_signature.timestamp': 'When the signature was generated and signed.',
  'process.code_signature.trusted': 'Stores the trust status of the certificate chain.',
  'process.code_signature.valid': 'Boolean to capture if the digital signature is verified against the binary content.',
  'process.command_line': 'Full command line that started the process.',
  'process.elf.architecture': 'Machine architecture of the ELF file.',
  'process.elf.byte_order': 'Byte sequence of ELF file.',
  'process.elf.cpu_type': 'CPU type of the ELF file.',
  'process.elf.creation_date': 'Build or compile date.',
  'process.elf.exports': 'List of exported element names and types.',
  'process.elf.go_import_hash': 'A hash of the Go language imports in an ELF file.',
  'process.elf.go_imports': 'List of imported Go language element names and types.',
  'process.elf.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'process.elf.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'process.elf.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'process.elf.header.abi_version': 'Version of the ELF Application Binary Interface (ABI).',
  'process.elf.header.class': 'Header class of the ELF file.',
  'process.elf.header.data': 'Data table of the ELF header.',
  'process.elf.header.entrypoint': 'Header entrypoint of the ELF file.',
  'process.elf.header.object_version': '"0x1" for original ELF files.',
  'process.elf.header.os_abi': 'Application Binary Interface (ABI) of the Linux OS.',
  'process.elf.header.type': 'Header type of the ELF file.',
  'process.elf.header.version': 'Version of the ELF header.',
  'process.elf.import_hash': 'A hash of the imports in an ELF file.',
  'process.elf.imports': 'List of imported element names and types.',
  'process.elf.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'process.elf.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'process.elf.sections': 'Section information of the ELF file.',
  'process.elf.sections.chi2': 'Chi-square probability distribution of the section.',
  'process.elf.sections.entropy': 'Shannon entropy calculation from the section.',
  'process.elf.sections.flags': 'ELF Section List flags.',
  'process.elf.sections.name': 'ELF Section List name.',
  'process.elf.sections.physical_offset': 'ELF Section List offset.',
  'process.elf.sections.physical_size': 'ELF Section List physical size.',
  'process.elf.sections.type': 'ELF Section List type.',
  'process.elf.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'process.elf.sections.virtual_address': 'ELF Section List virtual address.',
  'process.elf.sections.virtual_size': 'ELF Section List virtual size.',
  'process.elf.segments': 'ELF object segment list.',
  'process.elf.segments.sections': 'ELF object segment sections.',
  'process.elf.segments.type': 'ELF object segment type.',
  'process.elf.shared_libraries': 'List of shared libraries used by this ELF object.',
  'process.elf.telfhash': 'telfhash hash for ELF file.',
  'process.end': 'The time the process ended.',
  'process.entity_id': 'Unique identifier for the process.',
  'process.entry_leader.args': 'Array of process arguments.',
  'process.entry_leader.args_count': 'Length of the process.args array.',
  'process.entry_leader.attested_groups.name': 'Name of the group.',
  'process.entry_leader.attested_user.id': 'Unique identifier of the user.',
  'process.entry_leader.attested_user.name': 'Short name or login of the user.',
  'process.entry_leader.command_line': 'Full command line that started the process.',
  'process.entry_leader.entity_id': 'Unique identifier for the process.',
  'process.entry_leader.entry_meta.source.ip': 'IP address of the source.',
  'process.entry_leader.entry_meta.type': 'The entry type for the entry session leader.',
  'process.entry_leader.executable': 'Absolute path to the process executable.',
  'process.entry_leader.group.id': 'Unique identifier for the group on the system/platform.',
  'process.entry_leader.group.name': 'Name of the group.',
  'process.entry_leader.interactive': 'Whether the process is connected to an interactive shell.',
  'process.entry_leader.name': 'Process name.',
  'process.entry_leader.parent.entity_id': 'Unique identifier for the process.',
  'process.entry_leader.parent.pid': 'Process id.',
  'process.entry_leader.parent.session_leader.entity_id': 'Unique identifier for the process.',
  'process.entry_leader.parent.session_leader.pid': 'Process id.',
  'process.entry_leader.parent.session_leader.start': 'The time the process started.',
  'process.entry_leader.parent.session_leader.vpid': 'Virtual process id.',
  'process.entry_leader.parent.start': 'The time the process started.',
  'process.entry_leader.parent.vpid': 'Virtual process id.',
  'process.entry_leader.pid': 'Process id.',
  'process.entry_leader.real_group.id': 'Unique identifier for the group on the system/platform.',
  'process.entry_leader.real_group.name': 'Name of the group.',
  'process.entry_leader.real_user.id': 'Unique identifier of the user.',
  'process.entry_leader.real_user.name': 'Short name or login of the user.',
  'process.entry_leader.same_as_process': 'This boolean is used to identify if a leader process is the same as the top level process.',
  'process.entry_leader.saved_group.id': 'Unique identifier for the group on the system/platform.',
  'process.entry_leader.saved_group.name': 'Name of the group.',
  'process.entry_leader.saved_user.id': 'Unique identifier of the user.',
  'process.entry_leader.saved_user.name': 'Short name or login of the user.',
  'process.entry_leader.start': 'The time the process started.',
  'process.entry_leader.supplemental_groups.id': 'Unique identifier for the group on the system/platform.',
  'process.entry_leader.supplemental_groups.name': 'Name of the group.',
  'process.entry_leader.tty': 'Information about the controlling TTY device.',
  'process.entry_leader.tty.char_device.major': 'The TTY character devices major number.',
  'process.entry_leader.tty.char_device.minor': 'The TTY character devices minor number.',
  'process.entry_leader.user.id': 'Unique identifier of the user.',
  'process.entry_leader.user.name': 'Short name or login of the user.',
  'process.entry_leader.vpid': 'Virtual process id.',
  'process.entry_leader.working_directory': 'The working directory of the process.',
  'process.env_vars': 'Array of environment variable bindings.',
  'process.executable': 'Absolute path to the process executable.',
  'process.exit_code': 'The exit code of the process.',
  'process.group_leader.args': 'Array of process arguments.',
  'process.group_leader.args_count': 'Length of the process.args array.',
  'process.group_leader.command_line': 'Full command line that started the process.',
  'process.group_leader.entity_id': 'Unique identifier for the process.',
  'process.group_leader.executable': 'Absolute path to the process executable.',
  'process.group_leader.group.id': 'Unique identifier for the group on the system/platform.',
  'process.group_leader.group.name': 'Name of the group.',
  'process.group_leader.interactive': 'Whether the process is connected to an interactive shell.',
  'process.group_leader.name': 'Process name.',
  'process.group_leader.pid': 'Process id.',
  'process.group_leader.real_group.id': 'Unique identifier for the group on the system/platform.',
  'process.group_leader.real_group.name': 'Name of the group.',
  'process.group_leader.real_user.id': 'Unique identifier of the user.',
  'process.group_leader.real_user.name': 'Short name or login of the user.',
  'process.group_leader.same_as_process': 'This boolean is used to identify if a leader process is the same as the top level process.',
  'process.group_leader.saved_group.id': 'Unique identifier for the group on the system/platform.',
  'process.group_leader.saved_group.name': 'Name of the group.',
  'process.group_leader.saved_user.id': 'Unique identifier of the user.',
  'process.group_leader.saved_user.name': 'Short name or login of the user.',
  'process.group_leader.start': 'The time the process started.',
  'process.group_leader.supplemental_groups.id': 'Unique identifier for the group on the system/platform.',
  'process.group_leader.supplemental_groups.name': 'Name of the group.',
  'process.group_leader.tty': 'Information about the controlling TTY device.',
  'process.group_leader.tty.char_device.major': 'The TTY character devices major number.',
  'process.group_leader.tty.char_device.minor': 'The TTY character devices minor number.',
  'process.group_leader.user.id': 'Unique identifier of the user.',
  'process.group_leader.user.name': 'Short name or login of the user.',
  'process.group_leader.vpid': 'Virtual process id.',
  'process.group_leader.working_directory': 'The working directory of the process.',
  'process.hash.md5': 'MD5 hash.',
  'process.hash.sha1': 'SHA1 hash.',
  'process.hash.sha256': 'SHA256 hash.',
  'process.hash.sha384': 'SHA384 hash.',
  'process.hash.sha512': 'SHA512 hash.',
  'process.hash.ssdeep': 'SSDEEP hash.',
  'process.hash.tlsh': 'TLSH hash.',
  'process.interactive': 'Whether the process is connected to an interactive shell.',
  'process.io': 'A chunk of input or output (IO) from a single process.',
  'process.io.bytes_skipped': 'An array of byte offsets and lengths denoting where IO data has been skipped.',
  'process.io.bytes_skipped.length': 'The length of bytes skipped.',
  'process.io.bytes_skipped.offset': 'The byte offset into this events io.text (or io.bytes in the future) where length bytes were skipped.',
  'process.io.max_bytes_per_process_exceeded': 'If true, the process producing the output has exceeded the max_kilobytes_per_process configuration setting.',
  'process.io.text': 'A chunk of output or input sanitized to UTF-8.',
  'process.io.total_bytes_captured': 'The total number of bytes captured in this event.',
  'process.io.total_bytes_skipped': 'The total number of bytes that were not captured due to implementation restrictions such as buffer size limits.',
  'process.io.type': 'The type of object on which the IO action (read or write) was taken.',
  'process.macho.go_import_hash': 'A hash of the Go language imports in a Mach-O file.',
  'process.macho.go_imports': 'List of imported Go language element names and types.',
  'process.macho.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'process.macho.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'process.macho.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'process.macho.import_hash': 'A hash of the imports in a Mach-O file.',
  'process.macho.imports': 'List of imported element names and types.',
  'process.macho.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'process.macho.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'process.macho.sections': 'Section information of the Mach-O file.',
  'process.macho.sections.entropy': 'Shannon entropy calculation from the section.',
  'process.macho.sections.name': 'Mach-O Section List name.',
  'process.macho.sections.physical_size': 'Mach-O Section List physical size.',
  'process.macho.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'process.macho.sections.virtual_size': 'Mach-O Section List virtual size. This is always the same as `physical_size`.',
  'process.macho.symhash': 'A hash of the imports in a Mach-O file.',
  'process.name': 'Process name.',
  'process.parent.args': 'Array of process arguments.',
  'process.parent.args_count': 'Length of the process.args array.',
  'process.parent.code_signature.digest_algorithm': 'Hashing algorithm used to sign the process.',
  'process.parent.code_signature.exists': 'Boolean to capture if a signature is present.',
  'process.parent.code_signature.signing_id': 'The identifier used to sign the process.',
  'process.parent.code_signature.status': 'Additional information about the certificate status.',
  'process.parent.code_signature.subject_name': 'Subject name of the code signer',
  'process.parent.code_signature.team_id': 'The team identifier used to sign the process.',
  'process.parent.code_signature.timestamp': 'When the signature was generated and signed.',
  'process.parent.code_signature.trusted': 'Stores the trust status of the certificate chain.',
  'process.parent.code_signature.valid': 'Boolean to capture if the digital signature is verified against the binary content.',
  'process.parent.command_line': 'Full command line that started the process.',
  'process.parent.elf.architecture': 'Machine architecture of the ELF file.',
  'process.parent.elf.byte_order': 'Byte sequence of ELF file.',
  'process.parent.elf.cpu_type': 'CPU type of the ELF file.',
  'process.parent.elf.creation_date': 'Build or compile date.',
  'process.parent.elf.exports': 'List of exported element names and types.',
  'process.parent.elf.go_import_hash': 'A hash of the Go language imports in an ELF file.',
  'process.parent.elf.go_imports': 'List of imported Go language element names and types.',
  'process.parent.elf.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'process.parent.elf.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'process.parent.elf.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'process.parent.elf.header.abi_version': 'Version of the ELF Application Binary Interface (ABI).',
  'process.parent.elf.header.class': 'Header class of the ELF file.',
  'process.parent.elf.header.data': 'Data table of the ELF header.',
  'process.parent.elf.header.entrypoint': 'Header entrypoint of the ELF file.',
  'process.parent.elf.header.object_version': '"0x1" for original ELF files.',
  'process.parent.elf.header.os_abi': 'Application Binary Interface (ABI) of the Linux OS.',
  'process.parent.elf.header.type': 'Header type of the ELF file.',
  'process.parent.elf.header.version': 'Version of the ELF header.',
  'process.parent.elf.import_hash': 'A hash of the imports in an ELF file.',
  'process.parent.elf.imports': 'List of imported element names and types.',
  'process.parent.elf.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'process.parent.elf.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'process.parent.elf.sections': 'Section information of the ELF file.',
  'process.parent.elf.sections.chi2': 'Chi-square probability distribution of the section.',
  'process.parent.elf.sections.entropy': 'Shannon entropy calculation from the section.',
  'process.parent.elf.sections.flags': 'ELF Section List flags.',
  'process.parent.elf.sections.name': 'ELF Section List name.',
  'process.parent.elf.sections.physical_offset': 'ELF Section List offset.',
  'process.parent.elf.sections.physical_size': 'ELF Section List physical size.',
  'process.parent.elf.sections.type': 'ELF Section List type.',
  'process.parent.elf.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'process.parent.elf.sections.virtual_address': 'ELF Section List virtual address.',
  'process.parent.elf.sections.virtual_size': 'ELF Section List virtual size.',
  'process.parent.elf.segments': 'ELF object segment list.',
  'process.parent.elf.segments.sections': 'ELF object segment sections.',
  'process.parent.elf.segments.type': 'ELF object segment type.',
  'process.parent.elf.shared_libraries': 'List of shared libraries used by this ELF object.',
  'process.parent.elf.telfhash': 'telfhash hash for ELF file.',
  'process.parent.end': 'The time the process ended.',
  'process.parent.entity_id': 'Unique identifier for the process.',
  'process.parent.executable': 'Absolute path to the process executable.',
  'process.parent.exit_code': 'The exit code of the process.',
  'process.parent.group.id': 'Unique identifier for the group on the system/platform.',
  'process.parent.group.name': 'Name of the group.',
  'process.parent.group_leader.entity_id': 'Unique identifier for the process.',
  'process.parent.group_leader.pid': 'Process id.',
  'process.parent.group_leader.start': 'The time the process started.',
  'process.parent.group_leader.vpid': 'Virtual process id.',
  'process.parent.hash.md5': 'MD5 hash.',
  'process.parent.hash.sha1': 'SHA1 hash.',
  'process.parent.hash.sha256': 'SHA256 hash.',
  'process.parent.hash.sha384': 'SHA384 hash.',
  'process.parent.hash.sha512': 'SHA512 hash.',
  'process.parent.hash.ssdeep': 'SSDEEP hash.',
  'process.parent.hash.tlsh': 'TLSH hash.',
  'process.parent.interactive': 'Whether the process is connected to an interactive shell.',
  'process.parent.macho.go_import_hash': 'A hash of the Go language imports in a Mach-O file.',
  'process.parent.macho.go_imports': 'List of imported Go language element names and types.',
  'process.parent.macho.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'process.parent.macho.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'process.parent.macho.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'process.parent.macho.import_hash': 'A hash of the imports in a Mach-O file.',
  'process.parent.macho.imports': 'List of imported element names and types.',
  'process.parent.macho.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'process.parent.macho.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'process.parent.macho.sections': 'Section information of the Mach-O file.',
  'process.parent.macho.sections.entropy': 'Shannon entropy calculation from the section.',
  'process.parent.macho.sections.name': 'Mach-O Section List name.',
  'process.parent.macho.sections.physical_size': 'Mach-O Section List physical size.',
  'process.parent.macho.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'process.parent.macho.sections.virtual_size': 'Mach-O Section List virtual size. This is always the same as `physical_size`.',
  'process.parent.macho.symhash': 'A hash of the imports in a Mach-O file.',
  'process.parent.name': 'Process name.',
  'process.parent.pe.architecture': 'CPU architecture target for the file.',
  'process.parent.pe.company': 'Internal company name of the file, provided at compile-time.',
  'process.parent.pe.description': 'Internal description of the file, provided at compile-time.',
  'process.parent.pe.file_version': 'Process name.',
  'process.parent.pe.go_import_hash': 'A hash of the Go language imports in a PE file.',
  'process.parent.pe.go_imports': 'List of imported Go language element names and types.',
  'process.parent.pe.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'process.parent.pe.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'process.parent.pe.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'process.parent.pe.imphash': 'A hash of the imports in a PE file.',
  'process.parent.pe.import_hash': 'A hash of the imports in a PE file.',
  'process.parent.pe.imports': 'List of imported element names and types.',
  'process.parent.pe.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'process.parent.pe.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'process.parent.pe.original_file_name': 'Internal name of the file, provided at compile-time.',
  'process.parent.pe.pehash': 'A hash of the PE header and data from one or more PE sections.',
  'process.parent.pe.product': 'Internal product name of the file, provided at compile-time.',
  'process.parent.pe.sections': 'Section information of the PE file.',
  'process.parent.pe.sections.entropy': 'Shannon entropy calculation from the section.',
  'process.parent.pe.sections.name': 'PE Section List name.',
  'process.parent.pe.sections.physical_size': 'PE Section List physical size.',
  'process.parent.pe.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'process.parent.pe.sections.virtual_size': 'PE Section List virtual size. This is always the same as `physical_size`.',
  'process.parent.pgid': 'Deprecated identifier of the group of processes the process belongs to.',
  'process.parent.pid': 'Process id.',
  'process.parent.real_group.id': 'Unique identifier for the group on the system/platform.',
  'process.parent.real_group.name': 'Name of the group.',
  'process.parent.real_user.id': 'Unique identifier of the user.',
  'process.parent.real_user.name': 'Short name or login of the user.',
  'process.parent.saved_group.id': 'Unique identifier for the group on the system/platform.',
  'process.parent.saved_group.name': 'Name of the group.',
  'process.parent.saved_user.id': 'Unique identifier of the user.',
  'process.parent.saved_user.name': 'Short name or login of the user.',
  'process.parent.start': 'The time the process started.',
  'process.parent.supplemental_groups.id': 'Unique identifier for the group on the system/platform.',
  'process.parent.supplemental_groups.name': 'Name of the group.',
  'process.parent.thread.capabilities.effective': 'Array of capabilities used for permission checks.',
  'process.parent.thread.capabilities.permitted': 'Array of capabilities a thread could assume.',
  'process.parent.thread.id': 'Thread ID.',
  'process.parent.thread.name': 'Thread name.',
  'process.parent.title': 'Process title.',
  'process.parent.tty': 'Information about the controlling TTY device.',
  'process.parent.tty.char_device.major': 'The TTY character devices major number.',
  'process.parent.tty.char_device.minor': 'The TTY character devices minor number.',
  'process.parent.uptime': 'Seconds the process has been up.',
  'process.parent.user.id': 'Unique identifier of the user.',
  'process.parent.user.name': 'Short name or login of the user.',
  'process.parent.vpid': 'Virtual process id.',
  'process.parent.working_directory': 'The working directory of the process.',
  'process.pe.architecture': 'CPU architecture target for the file.',
  'process.pe.company': 'Internal company name of the file, provided at compile-time.',
  'process.pe.description': 'Internal description of the file, provided at compile-time.',
  'process.pe.file_version': 'Process name.',
  'process.pe.go_import_hash': 'A hash of the Go language imports in a PE file.',
  'process.pe.go_imports': 'List of imported Go language element names and types.',
  'process.pe.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'process.pe.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'process.pe.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'process.pe.imphash': 'A hash of the imports in a PE file.',
  'process.pe.import_hash': 'A hash of the imports in a PE file.',
  'process.pe.imports': 'List of imported element names and types.',
  'process.pe.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'process.pe.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'process.pe.original_file_name': 'Internal name of the file, provided at compile-time.',
  'process.pe.pehash': 'A hash of the PE header and data from one or more PE sections.',
  'process.pe.product': 'Internal product name of the file, provided at compile-time.',
  'process.pe.sections': 'Section information of the PE file.',
  'process.pe.sections.entropy': 'Shannon entropy calculation from the section.',
  'process.pe.sections.name': 'PE Section List name.',
  'process.pe.sections.physical_size': 'PE Section List physical size.',
  'process.pe.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'process.pe.sections.virtual_size': 'PE Section List virtual size. This is always the same as `physical_size`.',
  'process.pgid': 'Deprecated identifier of the group of processes the process belongs to.',
  'process.pid': 'Process id.',
  'process.previous.args': 'Array of process arguments.',
  'process.previous.args_count': 'Length of the process.args array.',
  'process.previous.executable': 'Absolute path to the process executable.',
  'process.real_group.id': 'Unique identifier for the group on the system/platform.',
  'process.real_group.name': 'Name of the group.',
  'process.real_user.id': 'Unique identifier of the user.',
  'process.real_user.name': 'Short name or login of the user.',
  'process.saved_group.id': 'Unique identifier for the group on the system/platform.',
  'process.saved_group.name': 'Name of the group.',
  'process.saved_user.id': 'Unique identifier of the user.',
  'process.saved_user.name': 'Short name or login of the user.',
  'process.session_leader.args': 'Array of process arguments.',
  'process.session_leader.args_count': 'Length of the process.args array.',
  'process.session_leader.command_line': 'Full command line that started the process.',
  'process.session_leader.entity_id': 'Unique identifier for the process.',
  'process.session_leader.executable': 'Absolute path to the process executable.',
  'process.session_leader.group.id': 'Unique identifier for the group on the system/platform.',
  'process.session_leader.group.name': 'Name of the group.',
  'process.session_leader.interactive': 'Whether the process is connected to an interactive shell.',
  'process.session_leader.name': 'Process name.',
  'process.session_leader.parent.entity_id': 'Unique identifier for the process.',
  'process.session_leader.parent.pid': 'Process id.',
  'process.session_leader.parent.session_leader.entity_id': 'Unique identifier for the process.',
  'process.session_leader.parent.session_leader.pid': 'Process id.',
  'process.session_leader.parent.session_leader.start': 'The time the process started.',
  'process.session_leader.parent.session_leader.vpid': 'Virtual process id.',
  'process.session_leader.parent.start': 'The time the process started.',
  'process.session_leader.parent.vpid': 'Virtual process id.',
  'process.session_leader.pid': 'Process id.',
  'process.session_leader.real_group.id': 'Unique identifier for the group on the system/platform.',
  'process.session_leader.real_group.name': 'Name of the group.',
  'process.session_leader.real_user.id': 'Unique identifier of the user.',
  'process.session_leader.real_user.name': 'Short name or login of the user.',
  'process.session_leader.same_as_process': 'This boolean is used to identify if a leader process is the same as the top level process.',
  'process.session_leader.saved_group.id': 'Unique identifier for the group on the system/platform.',
  'process.session_leader.saved_group.name': 'Name of the group.',
  'process.session_leader.saved_user.id': 'Unique identifier of the user.',
  'process.session_leader.saved_user.name': 'Short name or login of the user.',
  'process.session_leader.start': 'The time the process started.',
  'process.session_leader.supplemental_groups.id': 'Unique identifier for the group on the system/platform.',
  'process.session_leader.supplemental_groups.name': 'Name of the group.',
  'process.session_leader.tty': 'Information about the controlling TTY device.',
  'process.session_leader.tty.char_device.major': 'The TTY character devices major number.',
  'process.session_leader.tty.char_device.minor': 'The TTY character devices minor number.',
  'process.session_leader.user.id': 'Unique identifier of the user.',
  'process.session_leader.user.name': 'Short name or login of the user.',
  'process.session_leader.vpid': 'Virtual process id.',
  'process.session_leader.working_directory': 'The working directory of the process.',
  'process.start': 'The time the process started.',
  'process.supplemental_groups.id': 'Unique identifier for the group on the system/platform.',
  'process.supplemental_groups.name': 'Name of the group.',
  'process.thread.capabilities.effective': 'Array of capabilities used for permission checks.',
  'process.thread.capabilities.permitted': 'Array of capabilities a thread could assume.',
  'process.thread.id': 'Thread ID.',
  'process.thread.name': 'Thread name.',
  'process.title': 'Process title.',
  'process.tty': 'Information about the controlling TTY device.',
  'process.tty.char_device.major': 'The TTY character devices major number.',
  'process.tty.char_device.minor': 'The TTY character devices minor number.',
  'process.tty.columns': 'The number of character columns per line. e.g terminal width',
  'process.tty.rows': 'The number of character rows in the terminal. e.g terminal height',
  'process.uptime': 'Seconds the process has been up.',
  'process.user.id': 'Unique identifier of the user.',
  'process.user.name': 'Short name or login of the user.',
  'process.vpid': 'Virtual process id.',
  'process.working_directory': 'The working directory of the process.',
  'registry.data.bytes': 'Original bytes written with base64 encoding.',
  'registry.data.strings': 'List of strings representing what was written to the registry.',
  'registry.data.type': 'Standard registry type for encoding contents',
  'registry.hive': 'Abbreviated name for the hive.',
  'registry.key': 'Hive-relative path of keys.',
  'registry.path': 'Full path, including hive, key and value',
  'registry.value': 'Name of the value written.',
  'related.hash': 'All the hashes seen on your event.',
  'related.hosts': 'All the host identifiers seen on your event.',
  'related.ip': 'All of the IPs seen on your event.',
  'related.user': 'All the user names or other user identifiers seen on the event.',
  'rule.author': 'Rule author',
  'rule.category': 'Rule category',
  'rule.description': 'Rule description',
  'rule.id': 'Rule ID',
  'rule.license': 'Rule license',
  'rule.name': 'Rule name',
  'rule.reference': 'Rule reference URL',
  'rule.ruleset': 'Rule ruleset',
  'rule.uuid': 'Rule UUID',
  'rule.version': 'Rule version',
  'server.address': 'Server network address.',
  'server.as.number': 'Unique number allocated to the autonomous system.',
  'server.as.organization.name': 'Organization name.',
  'server.bytes': 'Bytes sent from the server to the client.',
  'server.domain': 'The domain name of the server.',
  'server.geo.city_name': 'City name.',
  'server.geo.continent_code': 'Continent code.',
  'server.geo.continent_name': 'Name of the continent.',
  'server.geo.country_iso_code': 'Country ISO code.',
  'server.geo.country_name': 'Country name.',
  'server.geo.location': 'Longitude and latitude.',
  'server.geo.name': 'User-defined description of a location.',
  'server.geo.postal_code': 'Postal code.',
  'server.geo.region_iso_code': 'Region ISO code.',
  'server.geo.region_name': 'Region name.',
  'server.geo.timezone': 'Time zone.',
  'server.ip': 'IP address of the server.',
  'server.mac': 'MAC address of the server.',
  'server.nat.ip': 'Server NAT ip',
  'server.nat.port': 'Server NAT port',
  'server.packets': 'Packets sent from the server to the client.',
  'server.port': 'Port of the server.',
  'server.registered_domain': 'The highest registered server domain, stripped of the subdomain.',
  'server.subdomain': 'The subdomain of the domain.',
  'server.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'server.user.domain': 'Name of the directory the user is a member of.',
  'server.user.email': 'User email address.',
  'server.user.full_name': 'Users full name, if available.',
  'server.user.group.domain': 'Name of the directory the group is a member of.',
  'server.user.group.id': 'Unique identifier for the group on the system/platform.',
  'server.user.group.name': 'Name of the group.',
  'server.user.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'server.user.id': 'Unique identifier of the user.',
  'server.user.name': 'Short name or login of the user.',
  'server.user.roles': 'Array of user roles at the time of the event.',
  'service.address': 'Address of this service.',
  'service.environment': 'Environment of the service.',
  'service.ephemeral_id': 'Ephemeral identifier of this service.',
  'service.id': 'Unique identifier of the running service.',
  'service.name': 'Name of the service.',
  'service.node.name': 'Name of the service node.',
  'service.node.role': 'Deprecated role (singular) of the service node.',
  'service.node.roles': 'Roles of the service node.',
  'service.origin.address': 'Address of this service.',
  'service.origin.environment': 'Environment of the service.',
  'service.origin.ephemeral_id': 'Ephemeral identifier of this service.',
  'service.origin.id': 'Unique identifier of the running service.',
  'service.origin.name': 'Name of the service.',
  'service.origin.node.name': 'Name of the service node.',
  'service.origin.node.role': 'Deprecated role (singular) of the service node.',
  'service.origin.node.roles': 'Roles of the service node.',
  'service.origin.state': 'Current state of the service.',
  'service.origin.type': 'The type of the service.',
  'service.origin.version': 'Version of the service.',
  'service.state': 'Current state of the service.',
  'service.target.address': 'Address of this service.',
  'service.target.environment': 'Environment of the service.',
  'service.target.ephemeral_id': 'Ephemeral identifier of this service.',
  'service.target.id': 'Unique identifier of the running service.',
  'service.target.name': 'Name of the service.',
  'service.target.node.name': 'Name of the service node.',
  'service.target.node.role': 'Deprecated role (singular) of the service node.',
  'service.target.node.roles': 'Roles of the service node.',
  'service.target.state': 'Current state of the service.',
  'service.target.type': 'The type of the service.',
  'service.target.version': 'Version of the service.',
  'service.type': 'The type of the service.',
  'service.version': 'Version of the service.',
  'source.address': 'Source network address.',
  'source.as.number': 'Unique number allocated to the autonomous system.',
  'source.as.organization.name': 'Organization name.',
  'source.bytes': 'Bytes sent from the source to the destination.',
  'source.domain': 'The domain name of the source.',
  'source.geo.city_name': 'City name.',
  'source.geo.continent_code': 'Continent code.',
  'source.geo.continent_name': 'Name of the continent.',
  'source.geo.country_iso_code': 'Country ISO code.',
  'source.geo.country_name': 'Country name.',
  'source.geo.location': 'Longitude and latitude.',
  'source.geo.name': 'User-defined description of a location.',
  'source.geo.postal_code': 'Postal code.',
  'source.geo.region_iso_code': 'Region ISO code.',
  'source.geo.region_name': 'Region name.',
  'source.geo.timezone': 'Time zone.',
  'source.ip': 'IP address of the source.',
  'source.mac': 'MAC address of the source.',
  'source.nat.ip': 'Source NAT ip',
  'source.nat.port': 'Source NAT port',
  'source.packets': 'Packets sent from the source to the destination.',
  'source.port': 'Port of the source.',
  'source.registered_domain': 'The highest registered source domain, stripped of the subdomain.',
  'source.subdomain': 'The subdomain of the domain.',
  'source.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'source.user.domain': 'Name of the directory the user is a member of.',
  'source.user.email': 'User email address.',
  'source.user.full_name': 'Users full name, if available.',
  'source.user.group.domain': 'Name of the directory the group is a member of.',
  'source.user.group.id': 'Unique identifier for the group on the system/platform.',
  'source.user.group.name': 'Name of the group.',
  'source.user.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'source.user.id': 'Unique identifier of the user.',
  'source.user.name': 'Short name or login of the user.',
  'source.user.roles': 'Array of user roles at the time of the event.',
  'span.id': 'Unique identifier of the span within the scope of its trace.',
  tags: 'List of keywords used to tag each event.',
  'threat.enrichments': 'List of objects containing indicators enriching the event.',
  'threat.enrichments.indicator': 'Object containing indicators enriching the event.',
  'threat.enrichments.indicator.as.number': 'Unique number allocated to the autonomous system.',
  'threat.enrichments.indicator.as.organization.name': 'Organization name.',
  'threat.enrichments.indicator.confidence': 'Indicator confidence rating',
  'threat.enrichments.indicator.description': 'Indicator description',
  'threat.enrichments.indicator.email.address': 'Indicator email address',
  'threat.enrichments.indicator.file.accessed': 'Last time the file was accessed.',
  'threat.enrichments.indicator.file.attributes': 'Array of file attributes.',
  'threat.enrichments.indicator.file.code_signature.digest_algorithm': 'Hashing algorithm used to sign the process.',
  'threat.enrichments.indicator.file.code_signature.exists': 'Boolean to capture if a signature is present.',
  'threat.enrichments.indicator.file.code_signature.signing_id': 'The identifier used to sign the process.',
  'threat.enrichments.indicator.file.code_signature.status': 'Additional information about the certificate status.',
  'threat.enrichments.indicator.file.code_signature.subject_name': 'Subject name of the code signer',
  'threat.enrichments.indicator.file.code_signature.team_id': 'The team identifier used to sign the process.',
  'threat.enrichments.indicator.file.code_signature.timestamp': 'When the signature was generated and signed.',
  'threat.enrichments.indicator.file.code_signature.trusted': 'Stores the trust status of the certificate chain.',
  'threat.enrichments.indicator.file.code_signature.valid': 'Boolean to capture if the digital signature is verified against the binary content.',
  'threat.enrichments.indicator.file.created': 'File creation time.',
  'threat.enrichments.indicator.file.ctime': 'Last time the file attributes or metadata changed.',
  'threat.enrichments.indicator.file.device': 'Device that is the source of the file.',
  'threat.enrichments.indicator.file.directory': 'Directory where the file is located.',
  'threat.enrichments.indicator.file.drive_letter': 'Drive letter where the file is located.',
  'threat.enrichments.indicator.file.elf.architecture': 'Machine architecture of the ELF file.',
  'threat.enrichments.indicator.file.elf.byte_order': 'Byte sequence of ELF file.',
  'threat.enrichments.indicator.file.elf.cpu_type': 'CPU type of the ELF file.',
  'threat.enrichments.indicator.file.elf.creation_date': 'Build or compile date.',
  'threat.enrichments.indicator.file.elf.exports': 'List of exported element names and types.',
  'threat.enrichments.indicator.file.elf.go_import_hash': 'A hash of the Go language imports in an ELF file.',
  'threat.enrichments.indicator.file.elf.go_imports': 'List of imported Go language element names and types.',
  'threat.enrichments.indicator.file.elf.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'threat.enrichments.indicator.file.elf.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'threat.enrichments.indicator.file.elf.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'threat.enrichments.indicator.file.elf.header.abi_version': 'Version of the ELF Application Binary Interface (ABI).',
  'threat.enrichments.indicator.file.elf.header.class': 'Header class of the ELF file.',
  'threat.enrichments.indicator.file.elf.header.data': 'Data table of the ELF header.',
  'threat.enrichments.indicator.file.elf.header.entrypoint': 'Header entrypoint of the ELF file.',
  'threat.enrichments.indicator.file.elf.header.object_version': '"0x1" for original ELF files.',
  'threat.enrichments.indicator.file.elf.header.os_abi': 'Application Binary Interface (ABI) of the Linux OS.',
  'threat.enrichments.indicator.file.elf.header.type': 'Header type of the ELF file.',
  'threat.enrichments.indicator.file.elf.header.version': 'Version of the ELF header.',
  'threat.enrichments.indicator.file.elf.import_hash': 'A hash of the imports in an ELF file.',
  'threat.enrichments.indicator.file.elf.imports': 'List of imported element names and types.',
  'threat.enrichments.indicator.file.elf.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'threat.enrichments.indicator.file.elf.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'threat.enrichments.indicator.file.elf.sections': 'Section information of the ELF file.',
  'threat.enrichments.indicator.file.elf.sections.chi2': 'Chi-square probability distribution of the section.',
  'threat.enrichments.indicator.file.elf.sections.entropy': 'Shannon entropy calculation from the section.',
  'threat.enrichments.indicator.file.elf.sections.flags': 'ELF Section List flags.',
  'threat.enrichments.indicator.file.elf.sections.name': 'ELF Section List name.',
  'threat.enrichments.indicator.file.elf.sections.physical_offset': 'ELF Section List offset.',
  'threat.enrichments.indicator.file.elf.sections.physical_size': 'ELF Section List physical size.',
  'threat.enrichments.indicator.file.elf.sections.type': 'ELF Section List type.',
  'threat.enrichments.indicator.file.elf.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'threat.enrichments.indicator.file.elf.sections.virtual_address': 'ELF Section List virtual address.',
  'threat.enrichments.indicator.file.elf.sections.virtual_size': 'ELF Section List virtual size.',
  'threat.enrichments.indicator.file.elf.segments': 'ELF object segment list.',
  'threat.enrichments.indicator.file.elf.segments.sections': 'ELF object segment sections.',
  'threat.enrichments.indicator.file.elf.segments.type': 'ELF object segment type.',
  'threat.enrichments.indicator.file.elf.shared_libraries': 'List of shared libraries used by this ELF object.',
  'threat.enrichments.indicator.file.elf.telfhash': 'telfhash hash for ELF file.',
  'threat.enrichments.indicator.file.extension': 'File extension, excluding the leading dot.',
  'threat.enrichments.indicator.file.fork_name': 'A fork is additional data associated with a filesystem object.',
  'threat.enrichments.indicator.file.gid': 'Primary group ID (GID) of the file.',
  'threat.enrichments.indicator.file.group': 'Primary group name of the file.',
  'threat.enrichments.indicator.file.hash.md5': 'MD5 hash.',
  'threat.enrichments.indicator.file.hash.sha1': 'SHA1 hash.',
  'threat.enrichments.indicator.file.hash.sha256': 'SHA256 hash.',
  'threat.enrichments.indicator.file.hash.sha384': 'SHA384 hash.',
  'threat.enrichments.indicator.file.hash.sha512': 'SHA512 hash.',
  'threat.enrichments.indicator.file.hash.ssdeep': 'SSDEEP hash.',
  'threat.enrichments.indicator.file.hash.tlsh': 'TLSH hash.',
  'threat.enrichments.indicator.file.inode': 'Inode representing the file in the filesystem.',
  'threat.enrichments.indicator.file.mime_type': 'Media type of file, document, or arrangement of bytes.',
  'threat.enrichments.indicator.file.mode': 'Mode of the file in octal representation.',
  'threat.enrichments.indicator.file.mtime': 'Last time the file content was modified.',
  'threat.enrichments.indicator.file.name': 'Name of the file including the extension, without the directory.',
  'threat.enrichments.indicator.file.owner': 'File owners username.',
  'threat.enrichments.indicator.file.path': 'Full path to the file, including the file name.',
  'threat.enrichments.indicator.file.pe.architecture': 'CPU architecture target for the file.',
  'threat.enrichments.indicator.file.pe.company': 'Internal company name of the file, provided at compile-time.',
  'threat.enrichments.indicator.file.pe.description': 'Internal description of the file, provided at compile-time.',
  'threat.enrichments.indicator.file.pe.file_version': 'Process name.',
  'threat.enrichments.indicator.file.pe.go_import_hash': 'A hash of the Go language imports in a PE file.',
  'threat.enrichments.indicator.file.pe.go_imports': 'List of imported Go language element names and types.',
  'threat.enrichments.indicator.file.pe.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'threat.enrichments.indicator.file.pe.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'threat.enrichments.indicator.file.pe.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'threat.enrichments.indicator.file.pe.imphash': 'A hash of the imports in a PE file.',
  'threat.enrichments.indicator.file.pe.import_hash': 'A hash of the imports in a PE file.',
  'threat.enrichments.indicator.file.pe.imports': 'List of imported element names and types.',
  'threat.enrichments.indicator.file.pe.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'threat.enrichments.indicator.file.pe.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'threat.enrichments.indicator.file.pe.original_file_name': 'Internal name of the file, provided at compile-time.',
  'threat.enrichments.indicator.file.pe.pehash': 'A hash of the PE header and data from one or more PE sections.',
  'threat.enrichments.indicator.file.pe.product': 'Internal product name of the file, provided at compile-time.',
  'threat.enrichments.indicator.file.pe.sections': 'Section information of the PE file.',
  'threat.enrichments.indicator.file.pe.sections.entropy': 'Shannon entropy calculation from the section.',
  'threat.enrichments.indicator.file.pe.sections.name': 'PE Section List name.',
  'threat.enrichments.indicator.file.pe.sections.physical_size': 'PE Section List physical size.',
  'threat.enrichments.indicator.file.pe.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'threat.enrichments.indicator.file.pe.sections.virtual_size': 'PE Section List virtual size. This is always the same as `physical_size`.',
  'threat.enrichments.indicator.file.size': 'File size in bytes.',
  'threat.enrichments.indicator.file.target_path': 'Target path for symlinks.',
  'threat.enrichments.indicator.file.type': 'File type (file, dir, or symlink).',
  'threat.enrichments.indicator.file.uid': 'The user ID (UID) or security identifier (SID) of the file owner.',
  'threat.enrichments.indicator.file.x509.alternative_names': 'List of subject alternative names (SAN).',
  'threat.enrichments.indicator.file.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'threat.enrichments.indicator.file.x509.issuer.country': 'List of country (C) codes',
  'threat.enrichments.indicator.file.x509.issuer.distinguished_name': 'Distinguished name (DN) of issuing certificate authority.',
  'threat.enrichments.indicator.file.x509.issuer.locality': 'List of locality names (L)',
  'threat.enrichments.indicator.file.x509.issuer.organization': 'List of organizations (O) of issuing certificate authority.',
  'threat.enrichments.indicator.file.x509.issuer.organizational_unit': 'List of organizational units (OU) of issuing certificate authority.',
  'threat.enrichments.indicator.file.x509.issuer.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.enrichments.indicator.file.x509.not_after': 'Time at which the certificate is no longer considered valid.',
  'threat.enrichments.indicator.file.x509.not_before': 'Time at which the certificate is first considered valid.',
  'threat.enrichments.indicator.file.x509.public_key_algorithm': 'Algorithm used to generate the public key.',
  'threat.enrichments.indicator.file.x509.public_key_curve': 'The curve used by the elliptic curve public key algorithm. This is algorithm specific.',
  'threat.enrichments.indicator.file.x509.public_key_exponent': 'Exponent used to derive the public key. This is algorithm specific.',
  'threat.enrichments.indicator.file.x509.public_key_size': 'The size of the public key space in bits.',
  'threat.enrichments.indicator.file.x509.serial_number': 'Unique serial number issued by the certificate authority.',
  'threat.enrichments.indicator.file.x509.signature_algorithm': 'Identifier for certificate signature algorithm.',
  'threat.enrichments.indicator.file.x509.subject.common_name': 'List of common names (CN) of subject.',
  'threat.enrichments.indicator.file.x509.subject.country': 'List of country (C) code',
  'threat.enrichments.indicator.file.x509.subject.distinguished_name': 'Distinguished name (DN) of the certificate subject entity.',
  'threat.enrichments.indicator.file.x509.subject.locality': 'List of locality names (L)',
  'threat.enrichments.indicator.file.x509.subject.organization': 'List of organizations (O) of subject.',
  'threat.enrichments.indicator.file.x509.subject.organizational_unit': 'List of organizational units (OU) of subject.',
  'threat.enrichments.indicator.file.x509.subject.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.enrichments.indicator.file.x509.version_number': 'Version of x509 format.',
  'threat.enrichments.indicator.first_seen': 'Date/time indicator was first reported.',
  'threat.enrichments.indicator.geo.city_name': 'City name.',
  'threat.enrichments.indicator.geo.continent_code': 'Continent code.',
  'threat.enrichments.indicator.geo.continent_name': 'Name of the continent.',
  'threat.enrichments.indicator.geo.country_iso_code': 'Country ISO code.',
  'threat.enrichments.indicator.geo.country_name': 'Country name.',
  'threat.enrichments.indicator.geo.location': 'Longitude and latitude.',
  'threat.enrichments.indicator.geo.name': 'User-defined description of a location.',
  'threat.enrichments.indicator.geo.postal_code': 'Postal code.',
  'threat.enrichments.indicator.geo.region_iso_code': 'Region ISO code.',
  'threat.enrichments.indicator.geo.region_name': 'Region name.',
  'threat.enrichments.indicator.geo.timezone': 'Time zone.',
  'threat.enrichments.indicator.ip': 'Indicator IP address',
  'threat.enrichments.indicator.last_seen': 'Date/time indicator was last reported.',
  'threat.enrichments.indicator.marking.tlp': 'Indicator TLP marking',
  'threat.enrichments.indicator.marking.tlp_version': 'Indicator TLP version',
  'threat.enrichments.indicator.modified_at': 'Date/time indicator was last updated.',
  'threat.enrichments.indicator.name': 'Indicator display name',
  'threat.enrichments.indicator.port': 'Indicator port',
  'threat.enrichments.indicator.provider': 'Indicator provider',
  'threat.enrichments.indicator.reference': 'Indicator reference URL',
  'threat.enrichments.indicator.registry.data.bytes': 'Original bytes written with base64 encoding.',
  'threat.enrichments.indicator.registry.data.strings': 'List of strings representing what was written to the registry.',
  'threat.enrichments.indicator.registry.data.type': 'Standard registry type for encoding contents',
  'threat.enrichments.indicator.registry.hive': 'Abbreviated name for the hive.',
  'threat.enrichments.indicator.registry.key': 'Hive-relative path of keys.',
  'threat.enrichments.indicator.registry.path': 'Full path, including hive, key and value',
  'threat.enrichments.indicator.registry.value': 'Name of the value written.',
  'threat.enrichments.indicator.scanner_stats': 'Scanner statistics',
  'threat.enrichments.indicator.sightings': 'Number of times indicator observed',
  'threat.enrichments.indicator.type': 'Type of indicator',
  'threat.enrichments.indicator.url.domain': 'Domain of the url.',
  'threat.enrichments.indicator.url.extension': 'File extension from the request url, excluding the leading dot.',
  'threat.enrichments.indicator.url.fragment': 'Portion of the url after the `#`.',
  'threat.enrichments.indicator.url.full': 'Full unparsed URL.',
  'threat.enrichments.indicator.url.original': 'Unmodified original url as seen in the event source.',
  'threat.enrichments.indicator.url.password': 'Password of the request.',
  'threat.enrichments.indicator.url.path': 'Path of the request, such as "/search".',
  'threat.enrichments.indicator.url.port': 'Port of the request, such as 443.',
  'threat.enrichments.indicator.url.query': 'Query string of the request.',
  'threat.enrichments.indicator.url.registered_domain': 'The highest registered url domain, stripped of the subdomain.',
  'threat.enrichments.indicator.url.scheme': 'Scheme of the url.',
  'threat.enrichments.indicator.url.subdomain': 'The subdomain of the domain.',
  'threat.enrichments.indicator.url.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'threat.enrichments.indicator.url.username': 'Username of the request.',
  'threat.enrichments.indicator.x509.alternative_names': 'List of subject alternative names (SAN).',
  'threat.enrichments.indicator.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'threat.enrichments.indicator.x509.issuer.country': 'List of country (C) codes',
  'threat.enrichments.indicator.x509.issuer.distinguished_name': 'Distinguished name (DN) of issuing certificate authority.',
  'threat.enrichments.indicator.x509.issuer.locality': 'List of locality names (L)',
  'threat.enrichments.indicator.x509.issuer.organization': 'List of organizations (O) of issuing certificate authority.',
  'threat.enrichments.indicator.x509.issuer.organizational_unit': 'List of organizational units (OU) of issuing certificate authority.',
  'threat.enrichments.indicator.x509.issuer.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.enrichments.indicator.x509.not_after': 'Time at which the certificate is no longer considered valid.',
  'threat.enrichments.indicator.x509.not_before': 'Time at which the certificate is first considered valid.',
  'threat.enrichments.indicator.x509.public_key_algorithm': 'Algorithm used to generate the public key.',
  'threat.enrichments.indicator.x509.public_key_curve': 'The curve used by the elliptic curve public key algorithm. This is algorithm specific.',
  'threat.enrichments.indicator.x509.public_key_exponent': 'Exponent used to derive the public key. This is algorithm specific.',
  'threat.enrichments.indicator.x509.public_key_size': 'The size of the public key space in bits.',
  'threat.enrichments.indicator.x509.serial_number': 'Unique serial number issued by the certificate authority.',
  'threat.enrichments.indicator.x509.signature_algorithm': 'Identifier for certificate signature algorithm.',
  'threat.enrichments.indicator.x509.subject.common_name': 'List of common names (CN) of subject.',
  'threat.enrichments.indicator.x509.subject.country': 'List of country (C) code',
  'threat.enrichments.indicator.x509.subject.distinguished_name': 'Distinguished name (DN) of the certificate subject entity.',
  'threat.enrichments.indicator.x509.subject.locality': 'List of locality names (L)',
  'threat.enrichments.indicator.x509.subject.organization': 'List of organizations (O) of subject.',
  'threat.enrichments.indicator.x509.subject.organizational_unit': 'List of organizational units (OU) of subject.',
  'threat.enrichments.indicator.x509.subject.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.enrichments.indicator.x509.version_number': 'Version of x509 format.',
  'threat.enrichments.matched.atomic': 'Matched indicator value',
  'threat.enrichments.matched.field': 'Matched indicator field',
  'threat.enrichments.matched.id': 'Matched indicator identifier',
  'threat.enrichments.matched.index': 'Matched indicator index',
  'threat.enrichments.matched.occurred': 'Date of match',
  'threat.enrichments.matched.type': 'Type of indicator match',
  'threat.feed.dashboard_id': 'Feed dashboard ID.',
  'threat.feed.description': 'Description of the threat feed.',
  'threat.feed.name': 'Name of the threat feed.',
  'threat.feed.reference': 'Reference for the threat feed.',
  'threat.framework': 'Threat classification framework.',
  'threat.group.alias': 'Alias of the group.',
  'threat.group.id': 'ID of the group.',
  'threat.group.name': 'Name of the group.',
  'threat.group.reference': 'Reference URL of the group.',
  'threat.indicator.as.number': 'Unique number allocated to the autonomous system.',
  'threat.indicator.as.organization.name': 'Organization name.',
  'threat.indicator.confidence': 'Indicator confidence rating',
  'threat.indicator.description': 'Indicator description',
  'threat.indicator.email.address': 'Indicator email address',
  'threat.indicator.file.accessed': 'Last time the file was accessed.',
  'threat.indicator.file.attributes': 'Array of file attributes.',
  'threat.indicator.file.code_signature.digest_algorithm': 'Hashing algorithm used to sign the process.',
  'threat.indicator.file.code_signature.exists': 'Boolean to capture if a signature is present.',
  'threat.indicator.file.code_signature.signing_id': 'The identifier used to sign the process.',
  'threat.indicator.file.code_signature.status': 'Additional information about the certificate status.',
  'threat.indicator.file.code_signature.subject_name': 'Subject name of the code signer',
  'threat.indicator.file.code_signature.team_id': 'The team identifier used to sign the process.',
  'threat.indicator.file.code_signature.timestamp': 'When the signature was generated and signed.',
  'threat.indicator.file.code_signature.trusted': 'Stores the trust status of the certificate chain.',
  'threat.indicator.file.code_signature.valid': 'Boolean to capture if the digital signature is verified against the binary content.',
  'threat.indicator.file.created': 'File creation time.',
  'threat.indicator.file.ctime': 'Last time the file attributes or metadata changed.',
  'threat.indicator.file.device': 'Device that is the source of the file.',
  'threat.indicator.file.directory': 'Directory where the file is located.',
  'threat.indicator.file.drive_letter': 'Drive letter where the file is located.',
  'threat.indicator.file.elf.architecture': 'Machine architecture of the ELF file.',
  'threat.indicator.file.elf.byte_order': 'Byte sequence of ELF file.',
  'threat.indicator.file.elf.cpu_type': 'CPU type of the ELF file.',
  'threat.indicator.file.elf.creation_date': 'Build or compile date.',
  'threat.indicator.file.elf.exports': 'List of exported element names and types.',
  'threat.indicator.file.elf.go_import_hash': 'A hash of the Go language imports in an ELF file.',
  'threat.indicator.file.elf.go_imports': 'List of imported Go language element names and types.',
  'threat.indicator.file.elf.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'threat.indicator.file.elf.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'threat.indicator.file.elf.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'threat.indicator.file.elf.header.abi_version': 'Version of the ELF Application Binary Interface (ABI).',
  'threat.indicator.file.elf.header.class': 'Header class of the ELF file.',
  'threat.indicator.file.elf.header.data': 'Data table of the ELF header.',
  'threat.indicator.file.elf.header.entrypoint': 'Header entrypoint of the ELF file.',
  'threat.indicator.file.elf.header.object_version': '"0x1" for original ELF files.',
  'threat.indicator.file.elf.header.os_abi': 'Application Binary Interface (ABI) of the Linux OS.',
  'threat.indicator.file.elf.header.type': 'Header type of the ELF file.',
  'threat.indicator.file.elf.header.version': 'Version of the ELF header.',
  'threat.indicator.file.elf.import_hash': 'A hash of the imports in an ELF file.',
  'threat.indicator.file.elf.imports': 'List of imported element names and types.',
  'threat.indicator.file.elf.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'threat.indicator.file.elf.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'threat.indicator.file.elf.sections': 'Section information of the ELF file.',
  'threat.indicator.file.elf.sections.chi2': 'Chi-square probability distribution of the section.',
  'threat.indicator.file.elf.sections.entropy': 'Shannon entropy calculation from the section.',
  'threat.indicator.file.elf.sections.flags': 'ELF Section List flags.',
  'threat.indicator.file.elf.sections.name': 'ELF Section List name.',
  'threat.indicator.file.elf.sections.physical_offset': 'ELF Section List offset.',
  'threat.indicator.file.elf.sections.physical_size': 'ELF Section List physical size.',
  'threat.indicator.file.elf.sections.type': 'ELF Section List type.',
  'threat.indicator.file.elf.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'threat.indicator.file.elf.sections.virtual_address': 'ELF Section List virtual address.',
  'threat.indicator.file.elf.sections.virtual_size': 'ELF Section List virtual size.',
  'threat.indicator.file.elf.segments': 'ELF object segment list.',
  'threat.indicator.file.elf.segments.sections': 'ELF object segment sections.',
  'threat.indicator.file.elf.segments.type': 'ELF object segment type.',
  'threat.indicator.file.elf.shared_libraries': 'List of shared libraries used by this ELF object.',
  'threat.indicator.file.elf.telfhash': 'telfhash hash for ELF file.',
  'threat.indicator.file.extension': 'File extension, excluding the leading dot.',
  'threat.indicator.file.fork_name': 'A fork is additional data associated with a filesystem object.',
  'threat.indicator.file.gid': 'Primary group ID (GID) of the file.',
  'threat.indicator.file.group': 'Primary group name of the file.',
  'threat.indicator.file.hash.md5': 'MD5 hash.',
  'threat.indicator.file.hash.sha1': 'SHA1 hash.',
  'threat.indicator.file.hash.sha256': 'SHA256 hash.',
  'threat.indicator.file.hash.sha384': 'SHA384 hash.',
  'threat.indicator.file.hash.sha512': 'SHA512 hash.',
  'threat.indicator.file.hash.ssdeep': 'SSDEEP hash.',
  'threat.indicator.file.hash.tlsh': 'TLSH hash.',
  'threat.indicator.file.inode': 'Inode representing the file in the filesystem.',
  'threat.indicator.file.mime_type': 'Media type of file, document, or arrangement of bytes.',
  'threat.indicator.file.mode': 'Mode of the file in octal representation.',
  'threat.indicator.file.mtime': 'Last time the file content was modified.',
  'threat.indicator.file.name': 'Name of the file including the extension, without the directory.',
  'threat.indicator.file.owner': 'File owners username.',
  'threat.indicator.file.path': 'Full path to the file, including the file name.',
  'threat.indicator.file.pe.architecture': 'CPU architecture target for the file.',
  'threat.indicator.file.pe.company': 'Internal company name of the file, provided at compile-time.',
  'threat.indicator.file.pe.description': 'Internal description of the file, provided at compile-time.',
  'threat.indicator.file.pe.file_version': 'Process name.',
  'threat.indicator.file.pe.go_import_hash': 'A hash of the Go language imports in a PE file.',
  'threat.indicator.file.pe.go_imports': 'List of imported Go language element names and types.',
  'threat.indicator.file.pe.go_imports_names_entropy': 'Shannon entropy calculation from the list of Go imports.',
  'threat.indicator.file.pe.go_imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of Go imports.',
  'threat.indicator.file.pe.go_stripped': 'Whether the file is a stripped or obfuscated Go executable.',
  'threat.indicator.file.pe.imphash': 'A hash of the imports in a PE file.',
  'threat.indicator.file.pe.import_hash': 'A hash of the imports in a PE file.',
  'threat.indicator.file.pe.imports': 'List of imported element names and types.',
  'threat.indicator.file.pe.imports_names_entropy': 'Shannon entropy calculation from the list of imported element names and types.',
  'threat.indicator.file.pe.imports_names_var_entropy': 'Variance for Shannon entropy calculation from the list of imported element names and types.',
  'threat.indicator.file.pe.original_file_name': 'Internal name of the file, provided at compile-time.',
  'threat.indicator.file.pe.pehash': 'A hash of the PE header and data from one or more PE sections.',
  'threat.indicator.file.pe.product': 'Internal product name of the file, provided at compile-time.',
  'threat.indicator.file.pe.sections': 'Section information of the PE file.',
  'threat.indicator.file.pe.sections.entropy': 'Shannon entropy calculation from the section.',
  'threat.indicator.file.pe.sections.name': 'PE Section List name.',
  'threat.indicator.file.pe.sections.physical_size': 'PE Section List physical size.',
  'threat.indicator.file.pe.sections.var_entropy': 'Variance for Shannon entropy calculation from the section.',
  'threat.indicator.file.pe.sections.virtual_size': 'PE Section List virtual size. This is always the same as `physical_size`.',
  'threat.indicator.file.size': 'File size in bytes.',
  'threat.indicator.file.target_path': 'Target path for symlinks.',
  'threat.indicator.file.type': 'File type (file, dir, or symlink).',
  'threat.indicator.file.uid': 'The user ID (UID) or security identifier (SID) of the file owner.',
  'threat.indicator.file.x509.alternative_names': 'List of subject alternative names (SAN).',
  'threat.indicator.file.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'threat.indicator.file.x509.issuer.country': 'List of country (C) codes',
  'threat.indicator.file.x509.issuer.distinguished_name': 'Distinguished name (DN) of issuing certificate authority.',
  'threat.indicator.file.x509.issuer.locality': 'List of locality names (L)',
  'threat.indicator.file.x509.issuer.organization': 'List of organizations (O) of issuing certificate authority.',
  'threat.indicator.file.x509.issuer.organizational_unit': 'List of organizational units (OU) of issuing certificate authority.',
  'threat.indicator.file.x509.issuer.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.indicator.file.x509.not_after': 'Time at which the certificate is no longer considered valid.',
  'threat.indicator.file.x509.not_before': 'Time at which the certificate is first considered valid.',
  'threat.indicator.file.x509.public_key_algorithm': 'Algorithm used to generate the public key.',
  'threat.indicator.file.x509.public_key_curve': 'The curve used by the elliptic curve public key algorithm. This is algorithm specific.',
  'threat.indicator.file.x509.public_key_exponent': 'Exponent used to derive the public key. This is algorithm specific.',
  'threat.indicator.file.x509.public_key_size': 'The size of the public key space in bits.',
  'threat.indicator.file.x509.serial_number': 'Unique serial number issued by the certificate authority.',
  'threat.indicator.file.x509.signature_algorithm': 'Identifier for certificate signature algorithm.',
  'threat.indicator.file.x509.subject.common_name': 'List of common names (CN) of subject.',
  'threat.indicator.file.x509.subject.country': 'List of country (C) code',
  'threat.indicator.file.x509.subject.distinguished_name': 'Distinguished name (DN) of the certificate subject entity.',
  'threat.indicator.file.x509.subject.locality': 'List of locality names (L)',
  'threat.indicator.file.x509.subject.organization': 'List of organizations (O) of subject.',
  'threat.indicator.file.x509.subject.organizational_unit': 'List of organizational units (OU) of subject.',
  'threat.indicator.file.x509.subject.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.indicator.file.x509.version_number': 'Version of x509 format.',
  'threat.indicator.first_seen': 'Date/time indicator was first reported.',
  'threat.indicator.geo.city_name': 'City name.',
  'threat.indicator.geo.continent_code': 'Continent code.',
  'threat.indicator.geo.continent_name': 'Name of the continent.',
  'threat.indicator.geo.country_iso_code': 'Country ISO code.',
  'threat.indicator.geo.country_name': 'Country name.',
  'threat.indicator.geo.location': 'Longitude and latitude.',
  'threat.indicator.geo.name': 'User-defined description of a location.',
  'threat.indicator.geo.postal_code': 'Postal code.',
  'threat.indicator.geo.region_iso_code': 'Region ISO code.',
  'threat.indicator.geo.region_name': 'Region name.',
  'threat.indicator.geo.timezone': 'Time zone.',
  'threat.indicator.ip': 'Indicator IP address',
  'threat.indicator.last_seen': 'Date/time indicator was last reported.',
  'threat.indicator.marking.tlp': 'Indicator TLP marking',
  'threat.indicator.marking.tlp_version': 'Indicator TLP version',
  'threat.indicator.modified_at': 'Date/time indicator was last updated.',
  'threat.indicator.name': 'Indicator display name',
  'threat.indicator.port': 'Indicator port',
  'threat.indicator.provider': 'Indicator provider',
  'threat.indicator.reference': 'Indicator reference URL',
  'threat.indicator.registry.data.bytes': 'Original bytes written with base64 encoding.',
  'threat.indicator.registry.data.strings': 'List of strings representing what was written to the registry.',
  'threat.indicator.registry.data.type': 'Standard registry type for encoding contents',
  'threat.indicator.registry.hive': 'Abbreviated name for the hive.',
  'threat.indicator.registry.key': 'Hive-relative path of keys.',
  'threat.indicator.registry.path': 'Full path, including hive, key and value',
  'threat.indicator.registry.value': 'Name of the value written.',
  'threat.indicator.scanner_stats': 'Scanner statistics',
  'threat.indicator.sightings': 'Number of times indicator observed',
  'threat.indicator.type': 'Type of indicator',
  'threat.indicator.url.domain': 'Domain of the url.',
  'threat.indicator.url.extension': 'File extension from the request url, excluding the leading dot.',
  'threat.indicator.url.fragment': 'Portion of the url after the `#`.',
  'threat.indicator.url.full': 'Full unparsed URL.',
  'threat.indicator.url.original': 'Unmodified original url as seen in the event source.',
  'threat.indicator.url.password': 'Password of the request.',
  'threat.indicator.url.path': 'Path of the request, such as "/search".',
  'threat.indicator.url.port': 'Port of the request, such as 443.',
  'threat.indicator.url.query': 'Query string of the request.',
  'threat.indicator.url.registered_domain': 'The highest registered url domain, stripped of the subdomain.',
  'threat.indicator.url.scheme': 'Scheme of the url.',
  'threat.indicator.url.subdomain': 'The subdomain of the domain.',
  'threat.indicator.url.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'threat.indicator.url.username': 'Username of the request.',
  'threat.indicator.x509.alternative_names': 'List of subject alternative names (SAN).',
  'threat.indicator.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'threat.indicator.x509.issuer.country': 'List of country (C) codes',
  'threat.indicator.x509.issuer.distinguished_name': 'Distinguished name (DN) of issuing certificate authority.',
  'threat.indicator.x509.issuer.locality': 'List of locality names (L)',
  'threat.indicator.x509.issuer.organization': 'List of organizations (O) of issuing certificate authority.',
  'threat.indicator.x509.issuer.organizational_unit': 'List of organizational units (OU) of issuing certificate authority.',
  'threat.indicator.x509.issuer.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.indicator.x509.not_after': 'Time at which the certificate is no longer considered valid.',
  'threat.indicator.x509.not_before': 'Time at which the certificate is first considered valid.',
  'threat.indicator.x509.public_key_algorithm': 'Algorithm used to generate the public key.',
  'threat.indicator.x509.public_key_curve': 'The curve used by the elliptic curve public key algorithm. This is algorithm specific.',
  'threat.indicator.x509.public_key_exponent': 'Exponent used to derive the public key. This is algorithm specific.',
  'threat.indicator.x509.public_key_size': 'The size of the public key space in bits.',
  'threat.indicator.x509.serial_number': 'Unique serial number issued by the certificate authority.',
  'threat.indicator.x509.signature_algorithm': 'Identifier for certificate signature algorithm.',
  'threat.indicator.x509.subject.common_name': 'List of common names (CN) of subject.',
  'threat.indicator.x509.subject.country': 'List of country (C) code',
  'threat.indicator.x509.subject.distinguished_name': 'Distinguished name (DN) of the certificate subject entity.',
  'threat.indicator.x509.subject.locality': 'List of locality names (L)',
  'threat.indicator.x509.subject.organization': 'List of organizations (O) of subject.',
  'threat.indicator.x509.subject.organizational_unit': 'List of organizational units (OU) of subject.',
  'threat.indicator.x509.subject.state_or_province': 'List of state or province names (ST, S, or P)',
  'threat.indicator.x509.version_number': 'Version of x509 format.',
  'threat.software.alias': 'Alias of the software',
  'threat.software.id': 'ID of the software',
  'threat.software.name': 'Name of the software.',
  'threat.software.platforms': 'Platforms of the software.',
  'threat.software.reference': 'Software reference URL.',
  'threat.software.type': 'Software type.',
  'threat.tactic.id': 'Threat tactic id.',
  'threat.tactic.name': 'Threat tactic.',
  'threat.tactic.reference': 'Threat tactic URL reference.',
  'threat.technique.id': 'Threat technique id.',
  'threat.technique.name': 'Threat technique name.',
  'threat.technique.reference': 'Threat technique URL reference.',
  'threat.technique.subtechnique.id': 'Threat subtechnique id.',
  'threat.technique.subtechnique.name': 'Threat subtechnique name.',
  'threat.technique.subtechnique.reference': 'Threat subtechnique URL reference.',
  'tls.cipher': 'String indicating the cipher used during the current connection.',
  'tls.client.certificate': 'PEM-encoded stand-alone certificate offered by the client.',
  'tls.client.certificate_chain': 'Array of PEM-encoded certificates that make up the certificate chain offered by the client.',
  'tls.client.hash.md5': 'Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client.',
  'tls.client.hash.sha1': 'Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client.',
  'tls.client.hash.sha256': 'Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client.',
  'tls.client.issuer': 'Distinguished name of subject of the issuer of the x.509 certificate presented by the client.',
  'tls.client.ja3': 'A hash that identifies clients based on how they perform an SSL/TLS handshake.',
  'tls.client.not_after': 'Date/Time indicating when client certificate is no longer considered valid.',
  'tls.client.not_before': 'Date/Time indicating when client certificate is first considered valid.',
  'tls.client.server_name': 'Hostname the client is trying to connect to. Also called the SNI.',
  'tls.client.subject': 'Distinguished name of subject of the x.509 certificate presented by the client.',
  'tls.client.supported_ciphers': 'Array of ciphers offered by the client during the client hello.',
  'tls.client.x509.alternative_names': 'List of subject alternative names (SAN).',
  'tls.client.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'tls.client.x509.issuer.country': 'List of country (C) codes',
  'tls.client.x509.issuer.distinguished_name': 'Distinguished name (DN) of issuing certificate authority.',
  'tls.client.x509.issuer.locality': 'List of locality names (L)',
  'tls.client.x509.issuer.organization': 'List of organizations (O) of issuing certificate authority.',
  'tls.client.x509.issuer.organizational_unit': 'List of organizational units (OU) of issuing certificate authority.',
  'tls.client.x509.issuer.state_or_province': 'List of state or province names (ST, S, or P)',
  'tls.client.x509.not_after': 'Time at which the certificate is no longer considered valid.',
  'tls.client.x509.not_before': 'Time at which the certificate is first considered valid.',
  'tls.client.x509.public_key_algorithm': 'Algorithm used to generate the public key.',
  'tls.client.x509.public_key_curve': 'The curve used by the elliptic curve public key algorithm. This is algorithm specific.',
  'tls.client.x509.public_key_exponent': 'Exponent used to derive the public key. This is algorithm specific.',
  'tls.client.x509.public_key_size': 'The size of the public key space in bits.',
  'tls.client.x509.serial_number': 'Unique serial number issued by the certificate authority.',
  'tls.client.x509.signature_algorithm': 'Identifier for certificate signature algorithm.',
  'tls.client.x509.subject.common_name': 'List of common names (CN) of subject.',
  'tls.client.x509.subject.country': 'List of country (C) code',
  'tls.client.x509.subject.distinguished_name': 'Distinguished name (DN) of the certificate subject entity.',
  'tls.client.x509.subject.locality': 'List of locality names (L)',
  'tls.client.x509.subject.organization': 'List of organizations (O) of subject.',
  'tls.client.x509.subject.organizational_unit': 'List of organizational units (OU) of subject.',
  'tls.client.x509.subject.state_or_province': 'List of state or province names (ST, S, or P)',
  'tls.client.x509.version_number': 'Version of x509 format.',
  'tls.curve': 'String indicating the curve used for the given cipher, when applicable.',
  'tls.established': 'Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.',
  'tls.next_protocol': 'String indicating the protocol being tunneled.',
  'tls.resumed': 'Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.',
  'tls.server.certificate': 'PEM-encoded stand-alone certificate offered by the server.',
  'tls.server.certificate_chain': 'Array of PEM-encoded certificates that make up the certificate chain offered by the server.',
  'tls.server.hash.md5': 'Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server.',
  'tls.server.hash.sha1': 'Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server.',
  'tls.server.hash.sha256': 'Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server.',
  'tls.server.issuer': 'Subject of the issuer of the x.509 certificate presented by the server.',
  'tls.server.ja3s': 'A hash that identifies servers based on how they perform an SSL/TLS handshake.',
  'tls.server.not_after': 'Timestamp indicating when server certificate is no longer considered valid.',
  'tls.server.not_before': 'Timestamp indicating when server certificate is first considered valid.',
  'tls.server.subject': 'Subject of the x.509 certificate presented by the server.',
  'tls.server.x509.alternative_names': 'List of subject alternative names (SAN).',
  'tls.server.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'tls.server.x509.issuer.country': 'List of country (C) codes',
  'tls.server.x509.issuer.distinguished_name': 'Distinguished name (DN) of issuing certificate authority.',
  'tls.server.x509.issuer.locality': 'List of locality names (L)',
  'tls.server.x509.issuer.organization': 'List of organizations (O) of issuing certificate authority.',
  'tls.server.x509.issuer.organizational_unit': 'List of organizational units (OU) of issuing certificate authority.',
  'tls.server.x509.issuer.state_or_province': 'List of state or province names (ST, S, or P)',
  'tls.server.x509.not_after': 'Time at which the certificate is no longer considered valid.',
  'tls.server.x509.not_before': 'Time at which the certificate is first considered valid.',
  'tls.server.x509.public_key_algorithm': 'Algorithm used to generate the public key.',
  'tls.server.x509.public_key_curve': 'The curve used by the elliptic curve public key algorithm. This is algorithm specific.',
  'tls.server.x509.public_key_exponent': 'Exponent used to derive the public key. This is algorithm specific.',
  'tls.server.x509.public_key_size': 'The size of the public key space in bits.',
  'tls.server.x509.serial_number': 'Unique serial number issued by the certificate authority.',
  'tls.server.x509.signature_algorithm': 'Identifier for certificate signature algorithm.',
  'tls.server.x509.subject.common_name': 'List of common names (CN) of subject.',
  'tls.server.x509.subject.country': 'List of country (C) code',
  'tls.server.x509.subject.distinguished_name': 'Distinguished name (DN) of the certificate subject entity.',
  'tls.server.x509.subject.locality': 'List of locality names (L)',
  'tls.server.x509.subject.organization': 'List of organizations (O) of subject.',
  'tls.server.x509.subject.organizational_unit': 'List of organizational units (OU) of subject.',
  'tls.server.x509.subject.state_or_province': 'List of state or province names (ST, S, or P)',
  'tls.server.x509.version_number': 'Version of x509 format.',
  'tls.version': 'Numeric part of the version parsed from the original string.',
  'tls.version_protocol': 'Normalized lowercase protocol name parsed from original string.',
  'trace.id': 'Unique identifier of the trace.',
  'transaction.id': 'Unique identifier of the transaction within the scope of its trace.',
  'url.domain': 'Domain of the url.',
  'url.extension': 'File extension from the request url, excluding the leading dot.',
  'url.fragment': 'Portion of the url after the `#`.',
  'url.full': 'Full unparsed URL.',
  'url.original': 'Unmodified original url as seen in the event source.',
  'url.password': 'Password of the request.',
  'url.path': 'Path of the request, such as "/search".',
  'url.port': 'Port of the request, such as 443.',
  'url.query': 'Query string of the request.',
  'url.registered_domain': 'The highest registered url domain, stripped of the subdomain.',
  'url.scheme': 'Scheme of the url.',
  'url.subdomain': 'The subdomain of the domain.',
  'url.top_level_domain': 'The effective top level domain (com, org, net, co.uk).',
  'url.username': 'Username of the request.',
  'user.changes.domain': 'Name of the directory the user is a member of.',
  'user.changes.email': 'User email address.',
  'user.changes.full_name': 'Users full name, if available.',
  'user.changes.group.domain': 'Name of the directory the group is a member of.',
  'user.changes.group.id': 'Unique identifier for the group on the system/platform.',
  'user.changes.group.name': 'Name of the group.',
  'user.changes.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'user.changes.id': 'Unique identifier of the user.',
  'user.changes.name': 'Short name or login of the user.',
  'user.changes.roles': 'Array of user roles at the time of the event.',
  'user.domain': 'Name of the directory the user is a member of.',
  'user.effective.domain': 'Name of the directory the user is a member of.',
  'user.effective.email': 'User email address.',
  'user.effective.full_name': 'Users full name, if available.',
  'user.effective.group.domain': 'Name of the directory the group is a member of.',
  'user.effective.group.id': 'Unique identifier for the group on the system/platform.',
  'user.effective.group.name': 'Name of the group.',
  'user.effective.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'user.effective.id': 'Unique identifier of the user.',
  'user.effective.name': 'Short name or login of the user.',
  'user.effective.roles': 'Array of user roles at the time of the event.',
  'user.email': 'User email address.',
  'user.full_name': 'Users full name, if available.',
  'user.group.domain': 'Name of the directory the group is a member of.',
  'user.group.id': 'Unique identifier for the group on the system/platform.',
  'user.group.name': 'Name of the group.',
  'user.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'user.id': 'Unique identifier of the user.',
  'user.name': 'Short name or login of the user.',
  'user.risk.calculated_level': 'A risk classification level calculated by an internal system as part of entity analytics and entity risk scoring.',
  'user.risk.calculated_score': 'A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring.',
  'user.risk.calculated_score_norm': 'A normalized risk score calculated by an internal system.',
  'user.risk.static_level': 'A risk classification level obtained from outside the system, such as from some external Threat Intelligence Platform.',
  'user.risk.static_score': 'A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform.',
  'user.risk.static_score_norm': 'A normalized risk score calculated by an external system.',
  'user.roles': 'Array of user roles at the time of the event.',
  'user.target.domain': 'Name of the directory the user is a member of.',
  'user.target.email': 'User email address.',
  'user.target.full_name': 'Users full name, if available.',
  'user.target.group.domain': 'Name of the directory the group is a member of.',
  'user.target.group.id': 'Unique identifier for the group on the system/platform.',
  'user.target.group.name': 'Name of the group.',
  'user.target.hash': 'Unique user hash to correlate information for a user in anonymized form.',
  'user.target.id': 'Unique identifier of the user.',
  'user.target.name': 'Short name or login of the user.',
  'user.target.roles': 'Array of user roles at the time of the event.',
  'user_agent.device.name': 'Name of the device.',
  'user_agent.name': 'Name of the user agent.',
  'user_agent.original': 'Unparsed user_agent string.',
  'user_agent.os.family': 'OS family (such as redhat, debian, freebsd, windows).',
  'user_agent.os.full': 'Operating system name, including the version or code name.',
  'user_agent.os.kernel': 'Operating system kernel version as a raw string.',
  'user_agent.os.name': 'Operating system name, without the version.',
  'user_agent.os.platform': 'Operating system platform (such centos, ubuntu, windows).',
  'user_agent.os.type': 'Which commercial OS family (one of: linux, macos, unix, windows, ios or android).',
  'user_agent.os.version': 'Operating system version as a raw string.',
  'user_agent.version': 'Version of the user agent.',
  'volume.bus_type': 'Bus type of the device.',
  'volume.default_access': 'Bus type of the device.',
  'volume.device_name': 'Device name of the volume.',
  'volume.device_type': 'Volume device type.',
  'volume.dos_name': 'DOS name of the device.',
  'volume.file_system_type': 'Volume device file system type.',
  'volume.mount_name': 'Mount name of the volume.',
  'volume.nt_name': 'NT name of the device.',
  'volume.product_id': 'ProductID of the device.',
  'volume.product_name': 'Produce name of the volume.',
  'volume.removable': 'Indicates if the volume is removable.',
  'volume.serial_number': 'Serial number of the device.',
  'volume.size': 'Size of the volume device in bytes.',
  'volume.vendor_id': 'VendorID of the device.',
  'volume.vendor_name': 'Vendor name of the device.',
  'volume.writable': 'Indicates if the volume is writable.',
  'vulnerability.category': 'Category of a vulnerability.',
  'vulnerability.classification': 'Classification of the vulnerability.',
  'vulnerability.description': 'Description of the vulnerability.',
  'vulnerability.enumeration': 'Identifier of the vulnerability.',
  'vulnerability.id': 'ID of the vulnerability.',
  'vulnerability.reference': 'Reference of the vulnerability.',
  'vulnerability.report_id': 'Scan identification number.',
  'vulnerability.scanner.vendor': 'Name of the scanner vendor.',
  'vulnerability.score.base': 'Vulnerability Base score.',
  'vulnerability.score.environmental': 'Vulnerability Environmental score.',
  'vulnerability.score.temporal': 'Vulnerability Temporal score.',
  'vulnerability.score.version': 'CVSS version.',
  'vulnerability.severity': 'Severity of the vulnerability.'
};