"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indicesSchema = exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Schema for APM indices
 */
const indicesSchema = exports.indicesSchema = _configSchema.schema.object({
  transaction: _configSchema.schema.string({
    defaultValue: 'traces-apm*,apm-*,traces-*.otel-*'
  }),
  // TODO: remove apm-* pattern in 9.0
  span: _configSchema.schema.string({
    defaultValue: 'traces-apm*,apm-*,traces-*.otel-*'
  }),
  error: _configSchema.schema.string({
    defaultValue: 'logs-apm*,apm-*,logs-*.otel-*'
  }),
  metric: _configSchema.schema.string({
    defaultValue: 'metrics-apm*,apm-*,metrics-*.otel-*'
  }),
  onboarding: _configSchema.schema.string({
    defaultValue: 'apm-*'
  }),
  // Unused: to be deleted
  sourcemap: _configSchema.schema.string({
    defaultValue: 'apm-*'
  }) // Unused: to be deleted
});

/**
 * Schema for APM Sources configuration
 */
const configSchema = exports.configSchema = _configSchema.schema.object({
  indices: indicesSchema
});

/**
 * Schema for APM Sources configuration
 */

/**
 * Schema for APM indices
 */