"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnifiedTraceErrors = getUnifiedTraceErrors;
var _get_trace_items = require("./get_trace_items");
var _get_unprocessed_otel_errors = require("./get_unprocessed_otel_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getUnifiedTraceErrors({
  apmEventClient,
  logsClient,
  traceId,
  docId,
  start,
  end
}) {
  const commonParams = {
    traceId,
    docId,
    start,
    end
  };
  const [apmErrors, unprocessedOtelErrors] = await Promise.all([(0, _get_trace_items.getApmTraceError)({
    apmEventClient,
    ...commonParams
  }), (0, _get_unprocessed_otel_errors.getUnprocessedOtelErrors)({
    logsClient,
    ...commonParams
  })]);
  return {
    apmErrors,
    unprocessedOtelErrors,
    totalErrors: apmErrors.length + unprocessedOtelErrors.length
  };
}