"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteApmSourceMap = deleteApmSourceMap;
var _server = require("@kbn/apm-sources-access-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteApmSourceMap({
  internalESClient,
  fleetId
}) {
  return internalESClient.deleteByQuery({
    index: _server.APM_SOURCE_MAP_INDEX,
    query: {
      bool: {
        filter: [{
          term: {
            fleet_id: fleetId
          }
        }]
      }
    }
  });
}