"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDestinationParentIds = getDestinationParentIds;
exports.getExitSpans = getExitSpans;
exports.getSourceSpanIds = getSourceSpanIds;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _apmTypes = require("@kbn/apm-types");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _compact_map = require("../../../utils/compact_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getExitSpans({
  apmEventClient,
  start,
  end,
  destinationNode,
  parentSpans
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.SERVICE_NAME, _apmTypes.SPAN_ID, _apmTypes.TRACE_ID, _apmTypes.TRANSACTION_ID, _apmTypes.SPAN_NAME, _apmTypes.SERVICE_NODE_NAME, _apmTypes.AGENT_NAME, _apmTypes.PARENT_ID]);
  const parentSpanIds = Array.from(parentSpans.keys());
  const response = await apmEventClient.search('diagnostics_get_exit_spans_from_source_node', {
    apm: {
      events: [_common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termsQuery)(_apmTypes.PARENT_ID, ...parentSpanIds)]
      }
    },
    aggs: {
      matching_destination_resources: {
        filter: {
          term: {
            [_apmTypes.SERVICE_NAME]: destinationNode
          }
        },
        aggs: {
          sample_docs: {
            top_hits: {
              size: 50,
              fields: [...requiredFields]
            }
          }
        }
      }
    }
  });
  const hits = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.matching_destination_resources) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.sample_docs) === null || _response$aggregation4 === void 0 ? void 0 : (_response$aggregation5 = _response$aggregation4.hits) === null || _response$aggregation5 === void 0 ? void 0 : _response$aggregation5.hits) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  const apmExitSpans = (0, _compact_map.compactMap)(hits, hit => {
    var _fields$SERVICE_NAME, _fields$SPAN_ID, _fields$TRANSACTION_I, _fields$SERVICE_NODE_, _fields$TRACE_ID, _fields$AGENT_NAME;
    const fields = (hit === null || hit === void 0 ? void 0 : hit.fields) && (0, _utils.accessKnownApmEventFields)(hit.fields);
    const parentId = fields === null || fields === void 0 ? void 0 : fields[_apmTypes.PARENT_ID];
    if (!fields || !parentId || !parentSpans.get(parentId)) {
      return;
    }
    return {
      destinationService: (_fields$SERVICE_NAME = fields[_apmTypes.SERVICE_NAME]) !== null && _fields$SERVICE_NAME !== void 0 ? _fields$SERVICE_NAME : '',
      spanId: (_fields$SPAN_ID = fields[_apmTypes.SPAN_ID]) !== null && _fields$SPAN_ID !== void 0 ? _fields$SPAN_ID : '',
      transactionId: (_fields$TRANSACTION_I = fields[_apmTypes.TRANSACTION_ID]) !== null && _fields$TRANSACTION_I !== void 0 ? _fields$TRANSACTION_I : '',
      serviceNodeName: (_fields$SERVICE_NODE_ = fields[_apmTypes.SERVICE_NODE_NAME]) !== null && _fields$SERVICE_NODE_ !== void 0 ? _fields$SERVICE_NODE_ : '',
      traceId: (_fields$TRACE_ID = fields[_apmTypes.TRACE_ID]) !== null && _fields$TRACE_ID !== void 0 ? _fields$TRACE_ID : '',
      agentName: (_fields$AGENT_NAME = fields[_apmTypes.AGENT_NAME]) !== null && _fields$AGENT_NAME !== void 0 ? _fields$AGENT_NAME : ''
    };
  });
  return {
    apmExitSpans,
    totalConnections: apmExitSpans.length,
    rawResponse: response,
    hasMatchingDestinationResources: apmExitSpans.length > 0
  };
}
async function getSourceSpanIds({
  apmEventClient,
  start,
  end,
  sourceNode,
  traceIds
}) {
  var _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.SPAN_ID]);
  const optionalFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE]);
  const response = await apmEventClient.search('diagnostics_get_source_node_span_samples', {
    apm: {
      events: [_common.ProcessorEvent.span, _common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termsQuery)(_apmTypes.TRACE_ID, ...traceIds)]
      }
    },
    aggs: {
      sample_docs: {
        composite: {
          size: 1000,
          sources: (0, _as_mutable_array.asMutableArray)([{
            serviceName: {
              terms: {
                field: _apmTypes.SERVICE_NAME
              }
            }
          }, {
            spanName: {
              terms: {
                field: _apmTypes.SPAN_NAME
              }
            }
          }])
        },
        aggs: {
          top_span_ids: {
            top_hits: {
              size: 10,
              fields: [...requiredFields, ...optionalFields]
            }
          }
        }
      }
    }
  });
  const destinationsBySpanId = new Map();
  return {
    sourceSpanIdsRawResponse: response,
    destinationsBySpanId: (_response$aggregation6 = (_response$aggregation7 = response.aggregations) === null || _response$aggregation7 === void 0 ? void 0 : (_response$aggregation8 = _response$aggregation7.sample_docs) === null || _response$aggregation8 === void 0 ? void 0 : (_response$aggregation9 = _response$aggregation8.buckets) === null || _response$aggregation9 === void 0 ? void 0 : _response$aggregation9.reduce((acc, bucket) => {
      const event = (0, _utils.accessKnownApmEventFields)(bucket.top_span_ids.hits.hits[0].fields).requireFields(requiredFields);
      acc.set(event[_apmTypes.SPAN_ID], event[_apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE]);
      return acc;
    }, destinationsBySpanId)) !== null && _response$aggregation6 !== void 0 ? _response$aggregation6 : destinationsBySpanId
  };
}
async function getDestinationParentIds({
  apmEventClient,
  start,
  end,
  parentSpans,
  destinationNode
}) {
  const parentSpanIds = Array.from(parentSpans.keys());
  const response = await apmEventClient.search('diagnostics_get_destination_node_parent_ids', {
    apm: {
      events: [_common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    size: 1,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(parentSpanIds ? (0, _server.termsQuery)(_apmTypes.PARENT_ID, ...parentSpanIds) : []), ...(0, _server.termQuery)(_apmTypes.SERVICE_NAME, destinationNode)]
      }
    },
    aggs: {
      sample_docs: {
        top_hits: {
          size: 5,
          fields: [_apmTypes.PARENT_ID, _apmTypes.SERVICE_NAME, _apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE]
        }
      }
    }
  });
  return {
    rawResponse: response,
    hasParent: response.hits.hits.length > 0
  };
}