"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeprecations = void 0;
var _apm_user_role = require("./apm_user_role");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerDeprecations = ({
  core,
  apmDeps
}) => {
  core.deprecations.registerDeprecations({
    getDeprecations: async ctx => {
      return [...(await (0, _apm_user_role.getDeprecationsInfo)(ctx, core, apmDeps))];
    }
  });
};
exports.registerDeprecations = registerDeprecations;