"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineAxisContainer = TimelineAxisContainer;
exports.VerticalLinesContainer = VerticalLinesContainer;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _plot_utils = require("./plot_utils");
var _timeline_axis = require("./timeline_axis");
var _vertical_lines = require("./vertical_lines");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeline/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TimelineAxisContainer({
  xMax,
  xMin,
  margins,
  marks,
  numberOfTicks
}) {
  const [width, setWidth] = (0, _react.useState)(0);
  if (xMax === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: size => setWidth(size.width),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, resizeRef => {
    const plotValues = (0, _plot_utils.getPlotValues)({
      width,
      xMin,
      xMax,
      margins,
      numberOfTicks
    });
    const topTraceDuration = xMax - (xMin !== null && xMin !== void 0 ? xMin : 0);
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%',
        height: '100%'
      },
      ref: resizeRef,
      "data-test-subj": "timeline-axis-container",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_timeline_axis.TimelineAxis, {
      plotValues: plotValues,
      marks: marks,
      topTraceDuration: topTraceDuration,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }));
  });
}
function VerticalLinesContainer({
  xMax,
  xMin,
  margins,
  marks
}) {
  const [width, setWidth] = (0, _react.useState)(0);
  if (xMax == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: size => setWidth(size.width),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, resizeRef => {
    const plotValues = (0, _plot_utils.getPlotValues)({
      width,
      xMin,
      xMax,
      margins
    });
    const topTraceDuration = xMax - (xMin !== null && xMin !== void 0 ? xMin : 0);
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%',
        height: '100%'
      },
      ref: resizeRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_vertical_lines.VerticalLines, {
      plotValues: plotValues,
      marks: marks,
      topTraceDuration: topTraceDuration,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }));
  });
}