"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectWithDefaultEnvironment = RedirectWithDefaultEnvironment;
var _reactRouterDom = require("react-router-dom");
var _queryString = _interopRequireDefault(require("query-string"));
var _react = _interopRequireDefault(require("react"));
var _use_default_environment = require("../../../../hooks/use_default_environment");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/app_root/redirect_with_default_environment/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RedirectWithDefaultEnvironment({
  children
}) {
  const location = (0, _reactRouterDom.useLocation)();
  const query = _queryString.default.parse(location.search);
  const defaultServiceEnvironment = (0, _use_default_environment.useDefaultEnvironment)();
  if ('environment' in query) {
    return children;
  }
  const normalizedPathname = location.pathname.replace(/\/$/, '');
  if (normalizedPathname === '/services') {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _queryString.default.stringifyUrl({
        url: location.pathname,
        query: {
          ...query,
          environment: defaultServiceEnvironment
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 7
      }
    });
  }
  return children;
}