"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentLatestVersion = AgentLatestVersion;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18n2 = require("../../../../../../common/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_explorer/agent_latest_version/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AgentLatestVersion({
  agentName,
  isLoading,
  latestVersion,
  failed
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const latestVersionElement = latestVersion ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, latestVersion) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n2.NOT_AVAILABLE_LABEL);
  const failedLatestVersionsElement = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.apm.agentExplorer.agentLatestVersion.airGappedMessage', {
      defaultMessage: 'The latest version of {agentName} agent could not be fetched from the repository. Please contact your administrator to check the server logs.',
      values: {
        agentName
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, _i18n2.NOT_AVAILABLE_LABEL));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "60px",
    height: euiTheme.size.l,
    borderRadius: "m",
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, !failed ? latestVersionElement : failedLatestVersionsElement);
}