"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDjangoAgentInstructions = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _agent_config_instructions = require("../agent_config_instructions");
var _instruction_variants = require("../instruction_variants");
var _api_key_callout = require("./api_key_callout");
var _agent_status_instructions = require("../agent_status_instructions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/instructions/django_agent.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createDjangoAgentInstructions = commonOptions => {
  const {
    baseUrl,
    apmServerUrl,
    apiKeyDetails,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  } = commonOptions;
  return [{
    title: _i18n.i18n.translate('xpack.apm.onboarding.django.install.title', {
      defaultMessage: 'Install the APM agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.django.install.textPre', {
      defaultMessage: 'Install the APM agent for Python as a dependency.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "bash",
      isCopyable: true,
      copyAriaLabel: _i18n.i18n.translate('xpack.apm.onboarding.django.install.copyAriaLabel', {
        defaultMessage: 'Copy the code to install the APM agent for Django'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }, "$ pip install elastic-apm"))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.django.configure.title', {
      defaultMessage: 'Configure the agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.django.configure.textPre', {
      defaultMessage: 'Agents are libraries that run inside of your application process. \
APM services are created programmatically based on the `SERVICE_NAME`.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }), ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
      isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
      isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
      errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: _instruction_variants.INSTRUCTION_VARIANT.DJANGO,
      apmServerUrl: apmServerUrl,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.django.configure.textPost', {
      defaultMessage: 'See the [documentation]({documentationLink}) for advanced usage.',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/agent/python/current/django-support.html`
      }
    })))
  }, (0, _agent_status_instructions.agentStatusCheckInstruction)({
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  })];
};
exports.createDjangoAgentInstructions = createDjangoAgentInstructions;