"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.adHocRunParamsModelVersions = void 0;
var _raw_ad_hoc_run_params = require("../schemas/raw_ad_hoc_run_params");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const adHocRunParamsModelVersions = exports.adHocRunParamsModelVersions = {
  '1': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_ad_hoc_run_params.rawAdHocRunParamsSchemaV1.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_ad_hoc_run_params.rawAdHocRunParamsSchemaV1
    }
  },
  '2': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_ad_hoc_run_params.rawAdHocRunParamsSchemaV2.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_ad_hoc_run_params.rawAdHocRunParamsSchemaV2
    }
  },
  '3': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        initiator: {
          type: 'keyword'
        },
        initiatorId: {
          type: 'keyword'
        }
      }
    }, {
      type: 'data_backfill',
      backfillFn: () => {
        return {
          attributes: {
            initiator: _constants.backfillInitiator.USER
          }
        };
      }
    }],
    schemas: {
      forwardCompatibility: _raw_ad_hoc_run_params.rawAdHocRunParamsSchemaV3.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_ad_hoc_run_params.rawAdHocRunParamsSchemaV3
    }
  }
};