"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.constructIgnoreInternalRuleTypesFilter = exports.combineFiltersWithInternalRuleTypeFilter = void 0;
var _esQuery = require("@kbn/es-query");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const constructIgnoreInternalRuleTypesFilter = ({
  ruleTypes
}) => {
  const internalRuleTypes = Array.from(ruleTypes.values()).filter(type => type.internallyManaged);
  if (internalRuleTypes.length === 0) {
    return null;
  }
  const internalRuleTypeNode = _esQuery.nodeBuilder.or(internalRuleTypes.map(type => _esQuery.nodeBuilder.is(`${_saved_objects.RULE_SAVED_OBJECT_TYPE}.attributes.alertTypeId`, type.id)));
  const internalRuleTypeNodesAsExpression = (0, _esQuery.toKqlExpression)(internalRuleTypeNode);
  const ignoreInternalRuleTypes = `not ${internalRuleTypeNodesAsExpression}`;
  return (0, _esQuery.fromKueryExpression)(ignoreInternalRuleTypes);
};
exports.constructIgnoreInternalRuleTypesFilter = constructIgnoreInternalRuleTypesFilter;
const combineFiltersWithInternalRuleTypeFilter = ({
  filter,
  internalRuleTypeFilter
}) => {
  if (!filter && !internalRuleTypeFilter) {
    return null;
  }
  if (!filter) {
    return internalRuleTypeFilter;
  }
  if (!internalRuleTypeFilter) {
    return filter;
  }
  return _esQuery.nodeBuilder.and([filter, internalRuleTypeFilter]);
};
exports.combineFiltersWithInternalRuleTypeFilter = combineFiltersWithInternalRuleTypeFilter;