"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rRuleSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validate_rrule_by = require("../../lib/validate_rrule_by");
var _validate_snooze_date = require("../../lib/validate_snooze_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rRuleSchema = exports.rRuleSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string({
    validate: _validate_snooze_date.validateSnoozeStartDate
  }),
  tzid: _configSchema.schema.string(),
  freq: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3)])),
  interval: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: interval => {
      if (!Number.isInteger(interval)) {
        return 'rRule interval must be an integer greater than 0';
      }
    },
    min: 1
  })),
  until: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: _validate_snooze_date.validateSnoozeEndDate
  })),
  count: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: count => {
      if (!Number.isInteger(count)) {
        return 'rRule count must be an integer greater than 0';
      }
    },
    min: 1
  })),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    validate: (0, _validate_rrule_by.createValidateRruleBy)('byweekday')
  })),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number(), {
    validate: (0, _validate_rrule_by.createValidateRruleBy)('bymonthday')
  })),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number(), {
    validate: (0, _validate_rrule_by.createValidateRruleBy)('bymonth')
  }))
});