"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findRuleTemplatesParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findRuleTemplatesParamsSchema = exports.findRuleTemplatesParamsSchema = _configSchema.schema.object({
  perPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  page: _configSchema.schema.maybe(_configSchema.schema.number()),
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  defaultSearchOperator: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('AND'), _configSchema.schema.literal('OR')])),
  sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  ruleTypeId: _configSchema.schema.maybe(_configSchema.schema.string()),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});