"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.systemActionSchema = exports.systemActionRequestSchema = exports.actionSchema = exports.actionRequestSchema = exports.actionParamsSchema = exports.actionFrequencySchema = exports.actionAlertsFilterTimeFrameSchema = exports.actionAlertsFilterSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _notify_when_schema = require("./notify_when_schema");
var _schemas = require("../../alerts_filter_query/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionParamsSchema = exports.actionParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
const actionAlertsFilterTimeFrameSchema = exports.actionAlertsFilterTimeFrameSchema = _configSchema.schema.object({
  days: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)])),
  hours: _configSchema.schema.object({
    start: _configSchema.schema.string(),
    end: _configSchema.schema.string()
  }),
  timezone: _configSchema.schema.string()
});
const actionAlertsFilterSchema = exports.actionAlertsFilterSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_schemas.alertsFilterQuerySchema),
  timeframe: _configSchema.schema.maybe(actionAlertsFilterTimeFrameSchema)
});
const actionFrequencySchema = exports.actionFrequencySchema = _configSchema.schema.object({
  summary: _configSchema.schema.boolean(),
  notifyWhen: _notify_when_schema.notifyWhenSchema,
  throttle: _configSchema.schema.nullable(_configSchema.schema.string())
});

/**
 * action schema, used by internal rules clients
 */
const actionSchema = exports.actionSchema = _configSchema.schema.object({
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  group: _configSchema.schema.string(),
  id: _configSchema.schema.string(),
  actionTypeId: _configSchema.schema.string(),
  params: actionParamsSchema,
  frequency: _configSchema.schema.maybe(actionFrequencySchema),
  alertsFilter: _configSchema.schema.maybe(actionAlertsFilterSchema),
  useAlertDataForTemplate: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const systemActionSchema = exports.systemActionSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  actionTypeId: _configSchema.schema.string(),
  params: actionParamsSchema,
  uuid: _configSchema.schema.maybe(_configSchema.schema.string())
});

/**
 * request action schema, actionTypeId field is optional, it really should not be required at all but
 * security solution is passing it in.
 */
const actionRequestSchema = exports.actionRequestSchema = _configSchema.schema.object({
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  group: _configSchema.schema.string(),
  id: _configSchema.schema.string(),
  actionTypeId: _configSchema.schema.maybe(_configSchema.schema.string()),
  params: actionParamsSchema,
  frequency: _configSchema.schema.maybe(actionFrequencySchema),
  alertsFilter: _configSchema.schema.maybe(actionAlertsFilterSchema),
  useAlertDataForTemplate: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const systemActionRequestSchema = exports.systemActionRequestSchema = _configSchema.schema.object({
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  actionTypeId: _configSchema.schema.maybe(_configSchema.schema.string()),
  id: _configSchema.schema.string(),
  params: actionParamsSchema
});