"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformUnmuteRequestToRuleAttributes = void 0;
var _transform_rule_mute_unmute_instance_ids = require("../../../transforms/transform_rule_mute_unmute_instance_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const removeInstanceIds = ({
  existingInstanceIds,
  instanceIdsFromRequest
}) => {
  const newMutedInstanceIds = existingInstanceIds.filter(id => !instanceIdsFromRequest.includes(id));
  if (newMutedInstanceIds.length === existingInstanceIds.length) {
    // No changes needed
    return;
  }
  return {
    mutedInstanceIds: newMutedInstanceIds,
    updatedAt: new Date().toISOString()
  };
};
const transformUnmuteRequestToRuleAttributes = ({
  paramRules,
  savedRules
}) => {
  return (0, _transform_rule_mute_unmute_instance_ids.transformMuteUnmuteRequestToRuleAttributes)({
    paramRules,
    savedRules,
    instanceIdCalculator: removeInstanceIds
  });
};
exports.transformUnmuteRequestToRuleAttributes = transformUnmuteRequestToRuleAttributes;