"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUpdatedRecoveredAlert = void 0;
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _format_alert = require("./format_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Updates an existing recovered alert document with latest flapping
 * information
 */

const buildUpdatedRecoveredAlert = ({
  alert,
  legacyRawAlert,
  runTimestamp,
  timestamp
}) => {
  var _legacyRawAlert$meta, _legacyRawAlert$meta2;
  // Make sure that any alert fields that are updatable are flattened.
  const refreshableAlertFields = (0, _format_alert.replaceRefreshableAlertFields)(alert);

  // Omit fields that are overwrite-able with undefined value
  const cleanedAlert = (0, _lodash.omit)(alert, _ruleDataUtils.ALERT_SEVERITY_IMPROVING);
  const alertUpdates = {
    // Update the timestamp to reflect latest update time
    [_ruleDataUtils.TIMESTAMP]: timestamp,
    [_ruleDataUtils.ALERT_RULE_EXECUTION_TIMESTAMP]: runTimestamp !== null && runTimestamp !== void 0 ? runTimestamp : timestamp,
    // Set latest flapping state
    [_ruleDataUtils.ALERT_FLAPPING]: (_legacyRawAlert$meta = legacyRawAlert.meta) === null || _legacyRawAlert$meta === void 0 ? void 0 : _legacyRawAlert$meta.flapping,
    // Set latest flapping history
    [_ruleDataUtils.ALERT_FLAPPING_HISTORY]: (_legacyRawAlert$meta2 = legacyRawAlert.meta) === null || _legacyRawAlert$meta2 === void 0 ? void 0 : _legacyRawAlert$meta2.flappingHistory,
    // For an "ongoing recovered" alert, we do not want to update the execution UUID to the current one so it does
    // not get returned for summary alerts. In the future, we may want to restore this and add another field to the
    // alert doc indicating that this is an ongoing recovered alert that can be used for querying.
    [_ruleDataUtils.ALERT_RULE_EXECUTION_UUID]: (0, _lodash.get)(alert, _ruleDataUtils.ALERT_RULE_EXECUTION_UUID),
    [_ruleDataUtils.ALERT_PREVIOUS_ACTION_GROUP]: (0, _lodash.get)(alert, _ruleDataUtils.ALERT_ACTION_GROUP)
  };

  // Clean the existing alert document so any nested fields that will be updated
  // are removed, to avoid duplicate data.
  // e.g. if the existing alert document has the field:
  // {
  //   kibana: {
  //     alert: {
  //       field1: 'value1'
  //     }
  //   }
  // }
  // and the updated alert has the field
  // {
  //   'kibana.alert.field1': 'value2'
  // }
  // the expanded field from the existing alert is removed
  const expandedAlert = (0, _format_alert.removeUnflattenedFieldsFromAlert)(cleanedAlert, {
    ...alertUpdates,
    ...refreshableAlertFields
  });
  return _deepmerge.default.all([expandedAlert, refreshableAlertFields, alertUpdates], {
    arrayMerge: (_, sourceArray) => sourceArray
  });
};
exports.buildUpdatedRecoveredAlert = buildUpdatedRecoveredAlert;