"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowScopedQuery = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _plugin = require("../../../../common/constants/plugin");
var _kibana_react = require("../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/components/maintenance_window_scoped_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MaintenanceWindowScopedQuery = exports.MaintenanceWindowScopedQuery = /*#__PURE__*/_react.default.memo(props => {
  const {
    ruleTypeIds,
    query,
    filters,
    errors = [],
    isLoading,
    isEnabled = true,
    onQueryChange,
    onFiltersChange
  } = props;
  const {
    http,
    data,
    notifications: {
      toasts
    },
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const onQueryChangeInternal = (0, _react.useCallback)(({
    query: newQuery
  }) => {
    onQueryChange(newQuery || '');
  }, [onQueryChange]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      "data-test-subj": "maintenanceWindowScopedQueryLoading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    })));
  }
  if (!isEnabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "maintenanceWindowScopeQuery",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: errors.length !== 0,
    error: errors[0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alertsUiShared.AlertsSearchBar, {
    appName: _plugin.PLUGIN.getI18nName(_i18n.i18n),
    ruleTypeIds: ruleTypeIds,
    disableQueryLanguageSwitcher: true,
    query: query,
    filters: filters,
    onQueryChange: onQueryChangeInternal,
    onQuerySubmit: onQueryChangeInternal,
    onFiltersUpdated: onFiltersChange,
    showFilterBar: true,
    submitOnBlur: true,
    showDatePicker: false,
    showSubmitButton: false,
    http: http,
    toasts: toasts,
    unifiedSearchBar: SearchBar,
    dataService: data,
    fetchUnifiedAlertsFields: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }))));
});