"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceContextProvider = exports.DataSourceContext = void 0;
exports.useDataSource = useDataSource;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/hooks/use_data_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataSourceContext = exports.DataSourceContext = /*#__PURE__*/(0, _react.createContext)({
  get dataView() {
    throw new Error('DataSourceContext is not implemented');
  },
  savedSearch: null
});
function useDataSource() {
  return (0, _react.useContext)(DataSourceContext);
}
/**
 * Context provider that resolves current data view and the saved search
 *
 * @param children
 * @constructor
 */
const DataSourceContextProvider = ({
  dataViews,
  dataViewId,
  children,
  onChange
}) => {
  const [value, setValue] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();

  /**
   * Resolve data view or saved search if exists.
   */
  const resolveDataSource = (0, _react.useCallback)(async () => {
    const dataViewAndSavedSearch = {
      savedSearch: null,
      // @ts-ignore
      dataView: null
    };

    // support only data views for now
    if (dataViewId) {
      dataViewAndSavedSearch.dataView = await dataViews.get(dataViewId);
    }
    const {
      savedSearch,
      dataView
    } = dataViewAndSavedSearch;
    return {
      dataView,
      savedSearch
    };
  }, [dataViewId, dataViews]);
  (0, _react.useEffect)(() => {
    resolveDataSource().then(result => {
      setError(undefined);
      setValue(result);
      if (onChange) {
        onChange({
          dataViews: [result.dataView]
        });
      }
    }).catch(e => {
      setError(e);
    });
  }, [resolveDataSource, onChange, dataViewId]);
  if ((!value || !(value !== null && value !== void 0 && value.dataView)) && !error) return null;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.dataSourceContext.errorTitle",
        defaultMessage: "Unable to fetch data view or Discover session",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 15
        }
      }, error.message),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(DataSourceContext.Provider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 10
    }
  }, children);
};
exports.DataSourceContextProvider = DataSourceContextProvider;