"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.P_VALUE_SIGNIFICANCE_MEDIUM = exports.P_VALUE_SIGNIFICANCE_HIGH = void 0;
exports.pValueToLabel = pValueToLabel;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const P_VALUE_SIGNIFICANCE_HIGH = exports.P_VALUE_SIGNIFICANCE_HIGH = 1e-6;
const P_VALUE_SIGNIFICANCE_MEDIUM = exports.P_VALUE_SIGNIFICANCE_MEDIUM = 0.001;
function pValueToLabel(pValue) {
  if (pValue <= P_VALUE_SIGNIFICANCE_HIGH) {
    return 'high';
  } else if (pValue <= P_VALUE_SIGNIFICANCE_MEDIUM) {
    return 'medium';
  } else {
    return 'low';
  }
}