"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsNavControlVisible = useIsNavControlVisible;
var _react = require("react");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _ui_setting_keys = require("../../common/ui_setting_keys");
var _ai_assistant_type = require("../../common/ai_assistant_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getVisibility(appId, applications, isUntouchedUiSetting, chatExperience, activeSpace) {
  var _applications$get, _applications$get$cat;
  // If AI Agents are enabled, hide the nav control
  // OnechatNavControl will be used instead
  if (chatExperience === _aiAssistantCommon.AIChatExperience.Agent) {
    return false;
  }
  const categoryId = appId && ((_applications$get = applications.get(appId)) === null || _applications$get === void 0 ? void 0 : (_applications$get$cat = _applications$get.category) === null || _applications$get$cat === void 0 ? void 0 : _applications$get$cat.id) || _public.DEFAULT_APP_CATEGORIES.kibana.id;
  const isSolutionPage = [_public.DEFAULT_APP_CATEGORIES.observability.id, _public.DEFAULT_APP_CATEGORIES.enterpriseSearch.id, _public.DEFAULT_APP_CATEGORIES.security.id].includes(categoryId);
  const isSolutionView = Boolean((activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution) && activeSpace.solution !== 'classic');
  return !isSolutionPage && isUntouchedUiSetting && !isSolutionView;
}

/**
 * Determines if the AI Assistant nav control selector should be visible.
 * Only visible on non-solution pages.
 *
 * @returns boolean
 */
function useIsNavControlVisible(coreStart, spaces) {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const {
    currentAppId$,
    applications$
  } = coreStart.application;
  const uiSetting$ = coreStart.settings.client.get$(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY, _ai_assistant_type.AIAssistantType.Default);
  const chatExperience$ = coreStart.settings.client.get$(_ui_setting_keys.PREFERRED_CHAT_EXPERIENCE_SETTING_KEY);
  const activeSpace$ = (0, _react.useMemo)(() => {
    var _spaces$getActiveSpac, _spaces$getActiveSpac2;
    return (_spaces$getActiveSpac = spaces === null || spaces === void 0 ? void 0 : (_spaces$getActiveSpac2 = spaces.getActiveSpace$) === null || _spaces$getActiveSpac2 === void 0 ? void 0 : _spaces$getActiveSpac2.call(spaces)) !== null && _spaces$getActiveSpac !== void 0 ? _spaces$getActiveSpac : (0, _rxjs.of)(undefined);
  }, [spaces]);
  (0, _react.useEffect)(() => {
    const appSubscription = (0, _rxjs.combineLatest)([currentAppId$, applications$, activeSpace$, uiSetting$, chatExperience$]).subscribe({
      next: ([appId, applications, activeSpace, _uiSetting, chatExperience]) => {
        const isUntouchedUiSetting = coreStart.settings.client.isDefault(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY);
        setIsVisible(getVisibility(appId, applications, isUntouchedUiSetting, chatExperience, activeSpace));
      }
    });
    return () => appSubscription.unsubscribe();
  }, [activeSpace$, chatExperience$, applications$, coreStart.settings.client, currentAppId$, uiSetting$]);
  return {
    isVisible
  };
}