"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsAiAgentsEnabled = getIsAiAgentsEnabled;
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the AI Agents feature is enabled via feature flag.
 * @param featureFlags - Feature flags service
 * @returns Boolean indicating if AI Agents are enabled
 */
function getIsAiAgentsEnabled(featureFlags) {
  return featureFlags.getBooleanValue(_.AI_AGENTS_FEATURE_FLAG, _.AI_AGENTS_FEATURE_FLAG_DEFAULT);
}