"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALIDATE_CONFIG_NODE = exports.MAX_RETRY_ATTEMPTS = exports.GENERATE_ESQL_NODE = exports.GENERATE_CONFIG_NODE = void 0;
exports.isGenerateConfigAction = isGenerateConfigAction;
exports.isGenerateEsqlAction = isGenerateEsqlAction;
exports.isValidateConfigAction = isValidateConfigAction;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isGenerateEsqlAction(action) {
  return action.type === 'generate_esql';
}
function isGenerateConfigAction(action) {
  return action.type === 'generate_config';
}
function isValidateConfigAction(action) {
  return action.type === 'validate_config';
}

// Node name constants
const GENERATE_ESQL_NODE = exports.GENERATE_ESQL_NODE = 'generate_esql_query';
const GENERATE_CONFIG_NODE = exports.GENERATE_CONFIG_NODE = 'generate_config';
const VALIDATE_CONFIG_NODE = exports.VALIDATE_CONFIG_NODE = 'validate_config';

// Configuration constants
const MAX_RETRY_ATTEMPTS = exports.MAX_RETRY_ATTEMPTS = 5;