"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.curryBuildPlanServiceNode = curryBuildPlanServiceNode;
const BindingConstraintsImplementation_1 = require("../../binding/models/BindingConstraintsImplementation");
const buildFilteredServiceBindings_1 = require("../calculations/buildFilteredServiceBindings");
const buildPlanBindingConstraintsList_1 = require("../calculations/buildPlanBindingConstraintsList");
const checkServiceNodeSingleInjectionBindings_1 = require("../calculations/checkServiceNodeSingleInjectionBindings");
function curryBuildPlanServiceNode(buildServiceNodeBindings) {
    return (params) => {
        const bindingConstraintsList = (0, buildPlanBindingConstraintsList_1.buildPlanBindingConstraintsList)(params);
        const bindingConstraints = new BindingConstraintsImplementation_1.BindingConstraintsImplementation(bindingConstraintsList.last);
        const chained = params.rootConstraints.isMultiple && params.rootConstraints.chained;
        const filteredServiceBindings = (0, buildFilteredServiceBindings_1.buildFilteredServiceBindings)(params, bindingConstraints, {
            chained,
        });
        const serviceNodeBindings = [];
        const serviceNode = {
            bindings: serviceNodeBindings,
            isContextFree: true,
            serviceIdentifier: params.rootConstraints.serviceIdentifier,
        };
        serviceNodeBindings.push(...buildServiceNodeBindings(params, bindingConstraintsList, filteredServiceBindings, serviceNode, chained));
        serviceNode.isContextFree =
            !bindingConstraintsList.last.elem.getAncestorsCalled;
        if (!params.rootConstraints.isMultiple) {
            (0, checkServiceNodeSingleInjectionBindings_1.checkServiceNodeSingleInjectionBindings)(serviceNode, params.rootConstraints.isOptional ?? false, bindingConstraintsList.last);
            const [planBindingNode] = serviceNodeBindings;
            serviceNode.bindings = planBindingNode;
        }
        return serviceNode;
    };
}
//# sourceMappingURL=curryBuildPlanServiceNode.js.map