"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClassMetadata = getClassMetadata;
const reflect_metadata_utils_1 = require("@inversifyjs/reflect-metadata-utils");
const classMetadataReflectKey_1 = require("../../reflectMetadata/data/classMetadataReflectKey");
const getDefaultClassMetadata_1 = require("./getDefaultClassMetadata");
const isPendingClassMetadata_1 = require("./isPendingClassMetadata");
const throwAtInvalidClassMetadata_1 = require("./throwAtInvalidClassMetadata");
const validateConstructorMetadataArray_1 = require("./validateConstructorMetadataArray");
function getClassMetadata(type) {
    const classMetadata = (0, reflect_metadata_utils_1.getOwnReflectMetadata)(type, classMetadataReflectKey_1.classMetadataReflectKey) ??
        (0, getDefaultClassMetadata_1.getDefaultClassMetadata)();
    if ((0, isPendingClassMetadata_1.isPendingClassMetadata)(type)) {
        (0, throwAtInvalidClassMetadata_1.throwAtInvalidClassMetadata)(type, classMetadata);
    }
    else {
        (0, validateConstructorMetadataArray_1.validateConstructorMetadataArray)(type, classMetadata.constructorArguments);
        return classMetadata;
    }
}
//# sourceMappingURL=getClassMetadata.js.map