"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BindingConstraintsImplementation = void 0;
class BindingConstraintsImplementation {
    #node;
    constructor(node) {
        this.#node = node;
    }
    get name() {
        return this.#node.elem.name;
    }
    get serviceIdentifier() {
        return this.#node.elem.serviceIdentifier;
    }
    get tags() {
        return this.#node.elem.tags;
    }
    getAncestor() {
        this.#node.elem.getAncestorsCalled = true;
        if (this.#node.previous === undefined) {
            return undefined;
        }
        return new BindingConstraintsImplementation(this.#node.previous);
    }
}
exports.BindingConstraintsImplementation = BindingConstraintsImplementation;
//# sourceMappingURL=BindingConstraintsImplementation.js.map