"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableTemplateSitewidePopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _popover = require("../../popover");
var _spacer = require("../../spacer");
var _selectable_template_sitewide = require("./selectable_template_sitewide.styles");
var _react2 = require("@emotion/react");
var _excluded = ["trigger", "search", "list", "title", "footer", "width", "isOpen", "panelRef", "closePopover"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiSelectableTemplateSitewidePopover = exports.EuiSelectableTemplateSitewidePopover = function EuiSelectableTemplateSitewidePopover(_ref) {
  var trigger = _ref.trigger,
    search = _ref.search,
    list = _ref.list,
    title = _ref.title,
    footer = _ref.footer,
    width = _ref.width,
    isOpen = _ref.isOpen,
    panelRef = _ref.panelRef,
    closePopover = _ref.closePopover,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_selectable_template_sitewide.euiSelectableTemplateSitewidePopoverStyles);
  return (0, _react2.jsx)(_popover.EuiPopover, _extends({
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    isOpen: isOpen,
    ownFocus: !!trigger,
    display: trigger ? 'inline-block' : 'block'
  }, rest, {
    panelRef: panelRef,
    button: trigger ? trigger : search,
    closePopover: closePopover,
    panelProps: {
      css: styles.euiSelectableTemplateSitewide__popover
    }
  }), (0, _react2.jsx)("div", {
    style: {
      width: width,
      maxWidth: '100%'
    }
  }, title || trigger ? (0, _react2.jsx)(_popover.EuiPopoverTitle, {
    paddingSize: "s"
  }, title, title && search && (0, _react2.jsx)(_spacer.EuiSpacer, null), search) : undefined, list, footer && (0, _react2.jsx)(_popover.EuiPopoverFooter, {
    paddingSize: "s"
  }, footer)));
};
EuiSelectableTemplateSitewidePopover.propTypes = {
  search: _propTypes.default.node.isRequired,
  list: _propTypes.default.node.isRequired,
  trigger: _propTypes.default.node,
  title: _propTypes.default.node,
  footer: _propTypes.default.node,
  width: _propTypes.default.any.isRequired,
  isOpen: _propTypes.default.bool.isRequired
};