"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutResizable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _flyout = require("./flyout");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// If not omitted, the correct props don't show up in the docs prop table

var EuiFlyoutResizable = exports.EuiFlyoutResizable = /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  return (0, _react2.jsx)(_flyout.EuiFlyout, _extends({
    ref: ref
  }, props, {
    resizable: true
  }));
});
EuiFlyoutResizable.propTypes = {
  maxWidth: _propTypes.default.number,
  /**
     * Controls the way the session is managed for this flyout.
     * - `start`: Creates a new flyout session. Use this for the main flyout.
     * - `inherit`: Inherits an existing session if one is active, otherwise functions as a standard flyout.
     * - `never`: Disregards session management and always functions as a standard flyout.
     *
     * When the `session` prop is undefined (not set), the flyout will automatically inherit from
     * a parent flyout if it's nested inside one. Otherwise, it defaults to `never`.
     *
     * Check out [EuiFlyout session management](https://eui.elastic.co/docs/components/containers/flyout/session-management)
     * documentation to learn more.
     * @default undefined (auto-inherit when nested, otherwise 'never')
     */
  session: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  /**
     * Callback fired when the flyout becomes active/visible, which may happen programmatically from history navigation.
     */
  onActive: _propTypes.default.func,
  /**
     * The HTML element to render as the flyout container.
     */
  as: _propTypes.default.any
};
EuiFlyoutResizable.displayName = 'EuiFlyoutResizable';