"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutOverlay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _overlay_mask = require("../overlay_mask");
var _portal = require("../portal");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var getEuiFlyoutOverlayStyles = function getEuiFlyoutOverlayStyles(zIndex) {
  /*
  This needs to have !important to override the default EuiOverlayMask
  z-index based on the headerZindexLocation prop. Using the style attribute
  doesn't work since EuiOverlayMask requires a string style prop that
  causes React errors in the test environment.
  */
  return /*#__PURE__*/(0, _css.css)("z-index:", zIndex, "!important;;label:getEuiFlyoutOverlayStyles;");
};

/**
 * Light wrapper for conditionally rendering portals or overlay masks:
 *  - If ownFocus is set, wrap with an overlay and allow the user to click it to close it.
 *  - Otherwise still wrap within an EuiPortal so it appends to the bottom of the window.
 * Push flyouts have no overlay OR portal behavior.
 *
 * @internal
 */
var EuiFlyoutOverlay = exports.EuiFlyoutOverlay = function EuiFlyoutOverlay(_ref) {
  var children = _ref.children,
    isPushed = _ref.isPushed,
    maskProps = _ref.maskProps,
    hasOverlayMask = _ref.hasOverlayMask,
    maskZIndex = _ref.maskZIndex;
  var styles = (0, _react.useMemo)(function () {
    return getEuiFlyoutOverlayStyles(maskZIndex);
  }, [maskZIndex]);
  var content = children;
  if (!isPushed || hasOverlayMask) {
    content = (0, _react2.jsx)(_portal.EuiPortal, null, content);
  }
  var classes = (0, _css.cx)(maskProps === null || maskProps === void 0 ? void 0 : maskProps.className, styles);
  return (0, _react2.jsx)(_react.default.Fragment, null, hasOverlayMask && (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, _extends({
    headerZindexLocation: "below"
  }, maskProps, {
    className: classes
  })), content);
};