"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRelativeTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _global_styling = require("../../../../global_styling");
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _accessibility = require("../../../accessibility");
var _flex = require("../../../flex");
var _form = require("../../../form");
var _popover = require("../../../popover");
var _spacer = require("../../../spacer");
var _date_modes = require("../date_modes");
var _relative_utils = require("../relative_utils");
var _timezone_display = require("./timezone_display");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiRelativeTab = exports.EuiRelativeTab = function EuiRelativeTab(_ref) {
  var _ref$timeOptions = _ref.timeOptions,
    relativeOptions = _ref$timeOptions.relativeOptions,
    relativeRoundingLabels = _ref$timeOptions.relativeRoundingLabels,
    dateFormat = _ref.dateFormat,
    locale = _ref.locale,
    value = _ref.value,
    onChange = _ref.onChange,
    roundUp = _ref.roundUp,
    labelPrefix = _ref.labelPrefix,
    _ref$timeZoneDisplayP = _ref.timeZoneDisplayProps,
    timeZoneDisplayProps = _ref$timeZoneDisplayP === void 0 ? {} : _ref$timeZoneDisplayP;
  var initialRelativeParts = (0, _react.useRef)((0, _relative_utils.parseRelativeParts)(value));
  var roundUnit = initialRelativeParts.current.roundUnit;
  var _useState = (0, _react.useState)(initialRelativeParts.current.unit),
    _useState2 = _slicedToArray(_useState, 2),
    unit = _useState2[0],
    setUnit = _useState2[1];
  var onUnitChange = (0, _react.useCallback)(function (event) {
    setUnit(event.target.value);
  }, []);
  var _useState3 = (0, _react.useState)(initialRelativeParts.current.round),
    _useState4 = _slicedToArray(_useState3, 2),
    round = _useState4[0],
    setRound = _useState4[1];
  var onRoundChange = (0, _react.useCallback)(function (event) {
    setRound(event.target.checked);
  }, []);
  var _useState5 = (0, _react.useState)(initialRelativeParts.current.count),
    _useState6 = _slicedToArray(_useState5, 2),
    count = _useState6[0],
    setCount = _useState6[1];
  var onCountChange = (0, _react.useCallback)(function (event) {
    var sanitizedValue = parseInt(event.target.value, 10);
    var count = isNaN(sanitizedValue) ? undefined : sanitizedValue;
    setCount(count);
  }, []);
  (0, _services.useUpdateEffect)(function () {
    if (count === undefined || count < 0) return;
    var date = (0, _relative_utils.toRelativeStringFromParts)({
      count: count,
      round: !!round,
      roundUnit: roundUnit,
      unit: unit
    });
    onChange(date);
  }, [onChange, count, round, roundUnit, unit]);
  var invalidDate = value === _date_modes.INVALID_DATE;
  var invalidValue = count === undefined || count < 0;
  var isInvalid = invalidValue || invalidDate;
  var formattedValue = (0, _react.useMemo)(function () {
    if (isInvalid) return '';
    var parsedValue = _datemath.default.parse(value, {
      roundUp: roundUp
    });
    if (!parsedValue || !parsedValue.isValid()) return '';
    return parsedValue.locale(locale || 'en').format(dateFormat);
  }, [isInvalid, value, roundUp, locale, dateFormat]);
  var textInputLabelId = (0, _services.useGeneratedHtmlId)();
  var relativeDateInputNumberDescriptionId = (0, _services.useGeneratedHtmlId)();
  var timeZomeDescriptionId = (0, _services.useGeneratedHtmlId)();
  var numberAriaLabel = (0, _i18n.useEuiI18n)('euiRelativeTab.numberInputLabel', 'Time span amount');
  var numberInputError = (0, _i18n.useEuiI18n)('euiRelativeTab.numberInputError', 'Must be >= 0');
  var dateInputError = (0, _i18n.useEuiI18n)('euiRelativeTab.dateInputError', 'Must be a valid range');
  var unitSelectAriaLabel = (0, _i18n.useEuiI18n)('euiRelativeTab.unitInputLabel', 'Relative time span');
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_form.EuiForm, {
    css: (0, _global_styling.useEuiPaddingCSS)().s
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_form.EuiFormRow, {
    isInvalid: isInvalid,
    error: invalidValue ? numberInputError : invalidDate ? dateInputError : null
  }, (0, _react2.jsx)(_form.EuiFieldNumber, {
    compressed: true,
    "aria-label": numberAriaLabel,
    "aria-describedby": relativeDateInputNumberDescriptionId,
    "data-test-subj": "superDatePickerRelativeDateInputNumber",
    value: count,
    onChange: onCountChange,
    isInvalid: isInvalid
  }))), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_form.EuiSelect, {
    compressed: true,
    "aria-label": unitSelectAriaLabel,
    "data-test-subj": "superDatePickerRelativeDateInputUnitSelector",
    value: unit,
    options: relativeOptions,
    onChange: onUnitChange
  }))), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  }), (0, _react2.jsx)(_form.EuiFieldText, {
    "aria-labelledby": textInputLabelId,
    compressed: true,
    value: formattedValue,
    readOnly: true,
    "aria-describedby": timeZomeDescriptionId,
    prepend: (0, _react2.jsx)(_form.EuiFormLabel, {
      id: textInputLabelId
    }, labelPrefix)
  }), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
    id: relativeDateInputNumberDescriptionId
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiRelativeTab.fullDescription",
    default: "The unit is changeable. Currently set to {unit}.",
    values: {
      unit: unit
    }
  })))), (0, _react2.jsx)(_timezone_display.EuiTimeZoneDisplay, _extends({
    id: timeZomeDescriptionId
  }, timeZoneDisplayProps)), (0, _react2.jsx)(_popover.EuiPopoverFooter, {
    paddingSize: "s"
  }, (0, _react2.jsx)(_form.EuiSwitch, {
    "data-test-subj": "superDatePickerRelativeDateRoundSwitch",
    label: relativeRoundingLabels[unit.substring(0, 1)],
    checked: !!round,
    onChange: onRoundChange
  })));
};
EuiRelativeTab.propTypes = {
  dateFormat: _propTypes.default.string.isRequired,
  locale: _propTypes.default.any,
  value: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired,
  roundUp: _propTypes.default.bool,
  labelPrefix: _propTypes.default.string.isRequired,
  timeOptions: _propTypes.default.shape({
    timeTenseOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    timeUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    relativeOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
      text: _propTypes.default.string.isRequired,
      value: _propTypes.default.oneOfType([_propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, _propTypes.default.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: _propTypes.default.any.isRequired,
    refreshUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    commonDurationRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
      end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
      label: _propTypes.default.string,
      start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired,
  timeZoneDisplayProps: _propTypes.default.shape({
    /**
       * A valid time zone name, from the IANA database, e.g. "America/Los_Angeles".
       *
       * @link https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
       */
    timeZone: _propTypes.default.string,
    /**
       * Render prop function to add additional content to the time zone display.
       * Useful for e.g. adding links to documentation or setting pages.
       */
    customRender: _propTypes.default.func,
    /**
       * Reference date to be used while resolving the UTC offset.
       * Only useful for edge cases involving daylight saving time.
       */
    date: _propTypes.default.any
  })
};