"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSlightShadowHover = exports.euiShadowXSmall = exports.euiShadowXLarge = exports.euiShadowSmall = exports.euiShadowMedium = exports.euiShadowLarge = exports.euiShadowHover = exports.euiShadowFlat = exports.euiShadow = void 0;
var _functions = require("../functions");
var _borders = require("./borders");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * x-small shadow
 */
var euiShadowXSmall = exports.euiShadowXSmall = function euiShadowXSmall(euiThemeContext, options) {
  var _options$direction;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction !== void 0 ? _options$direction : 'down';
  return _shadowStyles(euiThemeContext, euiTheme.shadows.xs[direction], {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};

/**
 * small shadow
 */
var euiShadowSmall = exports.euiShadowSmall = function euiShadowSmall(euiThemeContext, options) {
  var _options$direction2;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction2 = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction2 !== void 0 ? _options$direction2 : 'down';
  return _shadowStyles(euiThemeContext, euiTheme.shadows.s[direction], {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};

/**
 * medium shadow
 */
var euiShadowMedium = exports.euiShadowMedium = function euiShadowMedium(euiThemeContext, options) {
  var _options$direction3;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction3 = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction3 !== void 0 ? _options$direction3 : 'down';
  var boxShadow = euiTheme.shadows.m[direction];
  if ((options === null || options === void 0 ? void 0 : options.property) === 'filter') {
    return boxShadow ? _shadowStyles(euiThemeContext, (0, _functions.boxShadowToFilterDropShadow)(boxShadow), {
      border: options === null || options === void 0 ? void 0 : options.border,
      type: 'filter'
    }) : '';
  }
  return _shadowStyles(euiThemeContext, boxShadow, {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};

/**
 * large shadow
 */
var euiShadowLarge = exports.euiShadowLarge = function euiShadowLarge(euiThemeContext, options) {
  var _options$direction4;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction4 = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction4 !== void 0 ? _options$direction4 : 'down';
  return _shadowStyles(euiThemeContext, euiTheme.shadows.l[direction], {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};

/**
 * x-large shadow
 */

var euiShadowXLarge = exports.euiShadowXLarge = function euiShadowXLarge(euiThemeContext, options) {
  var _options$direction5;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction5 = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction5 !== void 0 ? _options$direction5 : 'down';
  return _shadowStyles(euiThemeContext, euiTheme.shadows.xl[direction], {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};

/**
 * flat shadow
 * @deprecated - use euiShadowHover instead
 */
var euiSlightShadowHover = exports.euiSlightShadowHover = function euiSlightShadowHover(euiThemeContext, options) {
  var _options$direction6;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction6 = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction6 !== void 0 ? _options$direction6 : 'down';
  return _shadowStyles(euiThemeContext, euiTheme.shadows.s[direction], {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};

/**
 * @deprecated - use euiShadowXSmall instead
 *
 * Similar to shadow medium but without the bottom depth.
 * Useful for popovers that drop UP rather than DOWN.
 */
var euiShadowFlat = exports.euiShadowFlat = function euiShadowFlat(euiThemeContext, options) {
  var _options$direction7, _euiTheme$shadows$fla;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction7 = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction7 !== void 0 ? _options$direction7 : 'down';
  var value = (_euiTheme$shadows$fla = euiTheme.shadows.flat) === null || _euiTheme$shadows$fla === void 0 ? void 0 : _euiTheme$shadows$fla[direction];
  return _shadowStyles(euiThemeContext, value, {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};
var euiShadow = exports.euiShadow = function euiShadow(euiThemeContext) {
  var size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'l';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  if (euiThemeContext.highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  switch (size) {
    case 'xs':
      return euiShadowXSmall(euiThemeContext, options);
    case 's':
      return euiShadowSmall(euiThemeContext, options);
    case 'm':
      return euiShadowMedium(euiThemeContext, options);
    case 'l':
      return euiShadowLarge(euiThemeContext, options);
    case 'xl':
      return euiShadowXLarge(euiThemeContext, options);
    default:
      console.warn('Please provide a valid size option to useEuiShadow');
      return '';
  }
};

/** Hover shadows */
var euiShadowHover = exports.euiShadowHover = function euiShadowHover(euiThemeContext) {
  var size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'base';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  if (euiThemeContext.highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  switch (size) {
    case 'base':
      return _euiShadowHover(euiThemeContext, 'base', options);
    case 'xs':
      return _euiShadowHover(euiThemeContext, 's', options);
    case 's':
      return _euiShadowHover(euiThemeContext, 'm', options);
    case 'm':
      return _euiShadowHover(euiThemeContext, 'l', options);
    case 'l':
      return _euiShadowHover(euiThemeContext, 'xl', options);
    case 'xl':
      return _euiShadowHover(euiThemeContext, 'xxl', options);
    default:
      console.warn('Please provide a valid size option to useEuiShadow');
      return '';
  }
};
var _euiShadowHover = function _euiShadowHover(euiThemeContext) {
  var _options$direction8;
  var size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'l';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiThemeContext, options);
  }
  var direction = (_options$direction8 = options === null || options === void 0 ? void 0 : options.direction) !== null && _options$direction8 !== void 0 ? _options$direction8 : 'down';
  var shadow = size === 'base' ? euiTheme.shadows.hover.base[direction] : size === 'xxl' ? euiTheme.shadows.hover.xl[direction] : euiTheme.shadows[size][direction];
  return _shadowStyles(euiThemeContext, shadow, {
    border: options === null || options === void 0 ? void 0 : options.border
  });
};

/**
 * Internal utilities for replacing shadows with high contrast borders instead.
 * NOTE: Windows' high contrast themes ignore *all* `box-shadow` CSS,
 * so we use `border` CSS explicitly instead of shadows
 */

var _highContrastBorder = function _highContrastBorder(euiThemeContext) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _ref$border = _ref.border,
    border = _ref$border === void 0 ? 'all' : _ref$border,
    borderAllInHighContrastMode = _ref.borderAllInHighContrastMode;
  var euiTheme = euiThemeContext.euiTheme;
  var hasFullBorder = borderAllInHighContrastMode || border && border !== 'none';
  return hasFullBorder ? "border: ".concat(euiTheme.border.thin, ";") : "border-block-end: ".concat(euiTheme.border.thin, ";");
};
var _shadowStyles = function _shadowStyles(euiThemeContext, shadow, options) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = euiTheme.flags.shadowVariant === 'refresh';
  var _options$border = options.border,
    border = _options$border === void 0 ? 'all' : _options$border,
    _options$type = options.type,
    type = _options$type === void 0 ? 'box-shadow' : _options$type;
  var borderStyle = euiThemeContext.colorMode === 'DARK' && border !== 'none' ? "".concat((0, _borders.euiShadowFloatingBorderStyles)(euiThemeContext, {
    side: border !== null && border !== void 0 ? border : 'all'
  })) : '';
  var shadowStyle = type === 'filter' ? shadow : "box-shadow: ".concat(shadow, ";");
  return "\n    ".concat(shadowStyle, ";\n    ").concat(isRefreshVariant && borderStyle, ";\n  ");
};