"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSection = exports.GROUPED_TABLE_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _table_section_context = require("./table_section_context");
var _group_stats_renderers = require("./group_stats_renderers");
var _grouping_options = require("./grouping_options");
var _group_title_renderers = require("./group_title_renderers");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _table = require("./table");
var _store = require("../../../../common/store");
var _use_selector = require("../../../../common/hooks/use_selector");
var _alerts_grouping = require("../../alerts_table/alerts_grouping");
var _group_stats_aggregations = require("./group_stats_aggregations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/table_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GROUPED_TABLE_TEST_ID = exports.GROUPED_TABLE_TEST_ID = 'alert-summary-grouped-table';
/**
 * Section rendering the table in the alert summary page.
 * This component leverages the GroupedAlertsTable and the ResponseOps AlertsTable also used in the alerts page.
 */
const TableSection = exports.TableSection = /*#__PURE__*/(0, _react.memo)(({
  dataView,
  packages
}) => {
  const dataViewSpec = (0, _react.useMemo)(() => dataView.toSpec(), [dataView]);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const globalQuery = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const getGlobalFiltersSelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersSelector);
  const accordionExtraActionGroupStats = (0, _react.useMemo)(() => ({
    aggregations: _group_stats_aggregations.groupStatsAggregations,
    renderer: _group_stats_renderers.groupStatsRenderer
  }), []);
  const renderChildComponent = (0, _react.useCallback)(groupingFilters => /*#__PURE__*/_react.default.createElement(_table.Table, {
    dataView: dataView,
    groupingFilters: groupingFilters,
    packages: packages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), [dataView, packages]);
  return /*#__PURE__*/_react.default.createElement(_table_section_context.TableSectionContextProvider, {
    packages: packages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": GROUPED_TABLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_grouping.GroupedAlertsTable, {
    accordionButtonContent: _group_title_renderers.groupTitleRenderers,
    accordionExtraActionGroupStats: accordionExtraActionGroupStats,
    dataView: dataView,
    dataViewSpec: dataViewSpec // TODO: newDataViewPickerEnabled - can be removed when old sourcerer is removed
    ,
    defaultGroupingOptions: _grouping_options.groupingOptions,
    from: from,
    globalFilters: filters,
    globalQuery: globalQuery,
    loading: false,
    renderChildComponent: renderChildComponent,
    tableId: _securitysolutionDataTable.TableId.alertsOnAlertSummaryPage,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })));
});
TableSection.displayName = 'TableSection';