"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActionsConfirmation = void 0;
var _react = require("react");
var _use_async_confirmation = require("../rules_table/use_async_confirmation");
var _use_bool_state = require("../../../../../common/hooks/use_bool_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * hook that controls bulk actions confirmation modal window and its content
 */
// TODO Why does this hook exist? Consider removing it altogether
const useBulkActionsConfirmation = () => {
  const [bulkAction, setBulkAction] = (0, _react.useState)();
  const [dryRunResult, setDryRunResult] = (0, _react.useState)();
  const [isBulkActionConfirmationVisible, showModal, hideModal] = (0, _use_bool_state.useBoolState)();
  const [confirmForm, onConfirm, onCancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showModal,
    onFinish: hideModal
  });
  const showBulkActionConfirmation = (0, _react.useCallback)(async (result, action) => {
    var _result$failedRulesCo;
    setBulkAction(action);
    setDryRunResult(result);

    // show bulk action confirmation window only if there is at least one failed rule, otherwise return early
    const hasFailedRules = ((_result$failedRulesCo = result === null || result === void 0 ? void 0 : result.failedRulesCount) !== null && _result$failedRulesCo !== void 0 ? _result$failedRulesCo : 0) > 0;
    // TODO Why is this logic here? Extract it out of this hook.
    if (!hasFailedRules) {
      return true;
    }
    const confirmation = await confirmForm();
    if (confirmation) {
      onConfirm();
    }
    return confirmation;
  }, [confirmForm, onConfirm]);
  return {
    bulkActionsDryRunResult: dryRunResult,
    bulkAction,
    isBulkActionConfirmationVisible,
    showBulkActionConfirmation,
    cancelBulkActionConfirmation: onCancel,
    approveBulkActionConfirmation: onConfirm
  };
};
exports.useBulkActionsConfirmation = useBulkActionsConfirmation;