"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formSchema = exports.ScheduleForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _shared_imports = require("../../../../../../shared_imports");
var _translations = require("../translations");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _schedule_item_field = require("../../../../../rule_creation/components/schedule_item_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/schedule_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formSchema = exports.formSchema = {
  interval: {
    label: _translations.bulkSetSchedule.INTERVAL_LABEL,
    helpText: _translations.bulkSetSchedule.INTERVAL_HELP_TEXT
  },
  lookback: {
    label: _translations.bulkSetSchedule.LOOKBACK_LABEL,
    helpText: _translations.bulkSetSchedule.LOOKBACK_HELP_TEXT
  }
};
const defaultFormData = {
  interval: '5m',
  lookback: '1m'
};
const ScheduleForm = ({
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: formSchema,
    defaultValue: defaultFormData
  });
  const handleSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    onConfirm({
      type: _rule_management.BulkActionEditTypeEnum.set_schedule,
      value: {
        interval: data.interval,
        lookback: data.lookback
      }
    });
  }, [form, onConfirm]);
  const warningCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "bulkEditRulesSchedulesWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, _translations.bulkSetSchedule.warningCalloutMessage(rulesCount));
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    title: _translations.bulkSetSchedule.FORM_TITLE,
    banner: warningCallout,
    onClose: onClose,
    onSubmit: handleSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "interval",
    component: _schedule_item_field.ScheduleItemField,
    componentProps: {
      idAria: 'bulkEditRulesScheduleIntervalSelector',
      dataTestSubj: 'bulkEditRulesScheduleIntervalSelector',
      fullWidth: true,
      minValue: 1
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "lookback",
    component: _schedule_item_field.ScheduleItemField,
    componentProps: {
      idAria: 'bulkEditRulesScheduleLookbackSelector',
      dataTestSubj: 'bulkEditRulesScheduleLookbackSelector',
      fullWidth: true,
      minValue: 1
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
};
exports.ScheduleForm = ScheduleForm;