"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForThreshold = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForThreshold = (oldFieldValue, newFieldValue) => {
  const changes = [];
  const oldField = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.field);
  const newField = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.field);
  if (oldField !== newField) {
    changes.push({
      subfieldName: 'field',
      oldSubfieldValue: oldField,
      newSubfieldValue: newField
    });
  }
  const oldValue = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.value);
  const newValue = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.value);
  if (oldValue !== newValue) {
    changes.push({
      subfieldName: 'value',
      oldSubfieldValue: oldValue,
      newSubfieldValue: newValue
    });
  }
  const oldCardinality = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.cardinality);
  const newCardinality = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.cardinality);
  if (oldCardinality !== newCardinality) {
    changes.push({
      subfieldName: 'cardinality',
      oldSubfieldValue: oldCardinality,
      newSubfieldValue: newCardinality
    });
  }
  return changes;
};
exports.getSubfieldChangesForThreshold = getSubfieldChangesForThreshold;