"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGapAutoFillCapabilities = void 0;
var _react = require("react");
var _keys = require("@kbn/security-solution-features/keys");
var _use_license = require("../../../common/hooks/use_license");
var _user_privileges = require("../../../common/components/user_privileges");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_product_feature_keys = require("../../../common/hooks/use_product_feature_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Centralized capability helper for everything related to the rule gaps auto-fill feature. ()
 */
const useGapAutoFillCapabilities = () => {
  const license = (0, _use_license.useLicense)();
  const productFeatureKeys = (0, _use_product_feature_keys.useProductFeatureKeys)();
  const gapAutoFillSchedulerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('gapAutoFillSchedulerEnabled');
  const hasEnterpriseLicense = license.isEnterprise();
  const hasRuleGapsAutoFillFeature = productFeatureKeys.has(_keys.ProductFeatureSecurityKey.ruleGapsAutoFill);
  const {
    edit: canEditRules,
    read: canReadRules
  } = (0, _user_privileges.useUserPrivileges)().rulesPrivileges;
  return (0, _react.useMemo)(() => ({
    hasEnterpriseLicense,
    canAccessGapAutoFill: gapAutoFillSchedulerEnabled && hasEnterpriseLicense && hasRuleGapsAutoFillFeature && canReadRules,
    canEditGapAutoFill: gapAutoFillSchedulerEnabled && hasEnterpriseLicense && hasRuleGapsAutoFillFeature && canEditRules
  }), [gapAutoFillSchedulerEnabled, hasEnterpriseLicense, hasRuleGapsAutoFillFeature, canEditRules, canReadRules]);
};
exports.useGapAutoFillCapabilities = useGapAutoFillCapabilities;