"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GapAutoFillStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _use_gap_auto_fill_scheduler = require("../../api/hooks/use_gap_auto_fill_scheduler");
var _translations = require("../../translations");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_settings_modal = require("../rule_settings_modal");
var _use_gap_auto_fill_capabilities = require("../../logic/use_gap_auto_fill_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rules_with_gaps_overview_panel/gap_auto_fill_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GapAutoFillStatus = exports.GapAutoFillStatus = /*#__PURE__*/_react.default.memo(() => {
  var _gapAutoFillScheduler;
  const {
    canAccessGapAutoFill
  } = (0, _use_gap_auto_fill_capabilities.useGapAutoFillCapabilities)();
  const {
    data: gapAutoFillScheduler,
    isLoading: isGapAutoFillSchedulerLoading
  } = (0, _use_gap_auto_fill_scheduler.useGetGapAutoFillScheduler)({
    enabled: canAccessGapAutoFill
  });
  const [isRuleSettingsModalOpen, openRuleSettingsModal, closeRuleSettingsModal] = (0, _use_bool_state.useBoolState)();
  const isStatusLoading = isGapAutoFillSchedulerLoading && !gapAutoFillScheduler;
  const isEnabled = (_gapAutoFillScheduler = gapAutoFillScheduler === null || gapAutoFillScheduler === void 0 ? void 0 : gapAutoFillScheduler.enabled) !== null && _gapAutoFillScheduler !== void 0 ? _gapAutoFillScheduler : false;
  if (!canAccessGapAutoFill) {
    return null;
  }
  const badgeLabel = isStatusLoading ? i18n.RULE_GAPS_OVERVIEW_PANEL_AUTO_GAP_FILL_STATUS_LOADING : isEnabled ? i18n.RULE_GAPS_OVERVIEW_PANEL_AUTO_GAP_FILL_STATUS_ON : i18n.RULE_GAPS_OVERVIEW_PANEL_AUTO_GAP_FILL_STATUS_OFF;
  const badgeColor = isEnabled ? 'success' : 'default';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": i18n.RULE_GAPS_OVERVIEW_PANEL_AUTO_GAP_FILL_STATUS_LABEL,
    content: _translations.GAP_AUTO_FILL_DESCRIPTION,
    type: "info",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, " ", i18n.RULE_GAPS_OVERVIEW_PANEL_AUTO_GAP_FILL_STATUS_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor,
    "data-test-subj": "gap-auto-fill-status-badge",
    onClick: openRuleSettingsModal,
    onClickAriaLabel: i18n.RULE_GAPS_OVERVIEW_PANEL_AUTO_GAP_FILL_STATUS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, badgeLabel)), isRuleSettingsModalOpen && /*#__PURE__*/_react.default.createElement(_rule_settings_modal.RuleSettingsModal, {
    isOpen: isRuleSettingsModalOpen,
    onClose: closeRuleSettingsModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }));
});
GapAutoFillStatus.displayName = 'GapAutoFillStatus';