"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GapAutoFillLogsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/alerting-plugin/common");
var _callouts = require("../../../../common/components/callouts");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_gap_auto_fill_scheduler = require("../../api/hooks/use_gap_auto_fill_scheduler");
var _multiselect_filter = require("../../../../common/components/multiselect_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/gap_auto_fill_logs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statuses = [_common.GAP_AUTO_FILL_STATUS.SUCCESS, _common.GAP_AUTO_FILL_STATUS.ERROR, _common.GAP_AUTO_FILL_STATUS.SKIPPED, _common.GAP_AUTO_FILL_STATUS.NO_GAPS];
const GapAutoFillLogsFlyout = ({
  isOpen,
  onClose
}) => {
  var _scheduler$schedule$i, _scheduler$schedule, _logsData$data, _logsData$total;
  const {
    data: scheduler
  } = (0, _use_gap_auto_fill_scheduler.useGetGapAutoFillScheduler)({
    enabled: isOpen
  });
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [selectedStatuses, setSelectedStatuses] = (0, _react.useState)([_common.GAP_AUTO_FILL_STATUS.SUCCESS, _common.GAP_AUTO_FILL_STATUS.ERROR]);
  const {
    data: logsData,
    isFetching: isLogsLoading
  } = (0, _use_gap_auto_fill_scheduler.useFindGapAutoFillSchedulerLogs)({
    page: pageIndex + 1,
    perPage: pageSize,
    statuses: selectedStatuses,
    sortField: '@timestamp',
    sortDirection: 'desc',
    enabled: isOpen
  });
  const [expandedRowMap, setExpandedRowMap] = (0, _react.useState)({});
  const enabled = scheduler === null || scheduler === void 0 ? void 0 : scheduler.enabled;
  const color = enabled ? 'success' : 'hollow';
  const iconType = enabled ? 'checkInCircleFilled' : 'minusInCircle';
  const getStatusLabel = status => {
    if (!status) return '';
    switch (status) {
      case _common.GAP_AUTO_FILL_STATUS.NO_GAPS:
        return i18n.GAP_AUTO_FILL_STATUS_NO_GAPS;
      case _common.GAP_AUTO_FILL_STATUS.SUCCESS:
        return i18n.GAP_AUTO_FILL_STATUS_SUCCESS;
      case _common.GAP_AUTO_FILL_STATUS.ERROR:
        return i18n.GAP_AUTO_FILL_STATUS_ERROR;
      case _common.GAP_AUTO_FILL_STATUS.SKIPPED:
        return i18n.GAP_AUTO_FILL_STATUS_SKIPPED;
      default:
        return status;
    }
  };
  const columns = (0, _react.useMemo)(() => [{
    field: 'timestamp',
    width: '100%',
    name: i18n.GAP_AUTO_FILL_RUN_TIME_COLUMN,
    render: timestamp => {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        value: timestamp,
        fieldName: 'timestamp',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 18
        }
      });
    }
  }, {
    field: 'status',
    align: 'center',
    width: '150px',
    name: i18n.GAP_AUTO_FILL_LOGS_STATUS_COLUMN,
    render: status => {
      let badgeColor;
      switch (status) {
        case _common.GAP_AUTO_FILL_STATUS.SUCCESS:
          badgeColor = 'success';
          break;
        case _common.GAP_AUTO_FILL_STATUS.ERROR:
          badgeColor = 'danger';
          break;
        case _common.GAP_AUTO_FILL_STATUS.SKIPPED:
        case _common.GAP_AUTO_FILL_STATUS.NO_GAPS:
        default:
          badgeColor = 'hollow';
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: badgeColor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 18
        }
      }, getStatusLabel(status));
    }
  }, {
    width: '120px',
    align: 'right',
    isExpander: true,
    render: item => {
      const itemIdToExpandedRowMapValues = {
        ...expandedRowMap
      };
      const isExpanded = itemIdToExpandedRowMapValues[item.id];
      const toggleViewLogs = () => {
        if (isExpanded) {
          delete itemIdToExpandedRowMapValues[item.id];
        } else {
          itemIdToExpandedRowMapValues[item.id] = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 139,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement("pre", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 140,
              columnNumber: 21
            }
          }, item.message)));
        }
        setExpandedRowMap(itemIdToExpandedRowMapValues);
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        color: "primary",
        onClick: toggleViewLogs,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 15
        }
      }, i18n.GAP_AUTO_FILL_LOGS_VIEW_LOGS_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: toggleViewLogs,
        "aria-label": isExpanded ? 'Collapse' : 'Expand',
        iconType: isExpanded ? 'arrowDown' : 'arrowRight',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 15
        }
      }));
    }
  }], [expandedRowMap]);
  const handlePaginationChange = (0, _react.useCallback)(({
    page
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
  }, []);
  if (!isOpen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "l",
    "aria-labelledby": "gapAutoFillLogs",
    "data-test-subj": "gap-auto-fill-logs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "gapAutoFillLogs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, i18n.GAP_AUTO_FILL_LOGS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_callouts.CallOutSwitcher, {
    namespace: "detections",
    condition: true,
    message: {
      type: 'primary',
      id: 'gap-auto-fill-logs',
      title: i18n.GAP_AUTO_FILL_LOGS_CALLOUT_TITLE,
      description: /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.gapAutoFillLogs.caloutDescription",
        defaultMessage: "The gap fill scheduler automatically checks for gaps in run executions and schedules backfills to cover them. The scheduler logs which gaps were scheduled to be filled, and whether they succeeded or failed. ",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 21
    }
  }, i18n.GAP_AUTO_FILL_STATUS_PANEL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    iconType: iconType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 19
    }
  }, enabled ? i18n.GAP_AUTO_FILL_ON_LABEL : i18n.GAP_AUTO_FILL_OFF_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 21
    }
  }, i18n.GAP_AUTO_FILL_SCHEDULE_PANEL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "clockCounter",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.gapAutoFillLogs.runsEveryLabel",
    defaultMessage: "Runs every {interval}",
    values: {
      interval: (_scheduler$schedule$i = scheduler === null || scheduler === void 0 ? void 0 : (_scheduler$schedule = scheduler.schedule) === null || _scheduler$schedule === void 0 ? void 0 : _scheduler$schedule.interval) !== null && _scheduler$schedule$i !== void 0 ? _scheduler$schedule$i : '—'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 19
    }
  }, i18n.GAP_AUTO_FILL_LOGS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    "data-test-subj": "gap-auto-fill-logs-status-filter",
    title: i18n.GAP_AUTO_FILL_STATUS_FILTER_TITLE,
    items: statuses,
    selectedItems: selectedStatuses,
    onSelectionChange: items => setSelectedStatuses(items),
    renderItem: s => getStatusLabel(s),
    width: 200,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLogsLoading,
    items: (_logsData$data = logsData === null || logsData === void 0 ? void 0 : logsData.data) !== null && _logsData$data !== void 0 ? _logsData$data : [],
    itemId: "id",
    columns: columns,
    pagination: {
      pageIndex,
      pageSize,
      totalItemCount: (_logsData$total = logsData === null || logsData === void 0 ? void 0 : logsData.total) !== null && _logsData$total !== void 0 ? _logsData$total : 0,
      pageSizeOptions: [10, 25, 50]
    },
    onChange: handlePaginationChange,
    itemIdToExpandedRowMap: expandedRowMap,
    "data-test-subj": "gap-auto-fill-logs-table",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  })))));
};
exports.GapAutoFillLogsFlyout = GapAutoFillLogsFlyout;