"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CLOSE_ALERTS_SUCCESS = exports.CLOSE_ALERTS_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOSE_ALERTS_SUCCESS = numAlerts => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.logic.closeAlerts.success', {
  values: {
    numAlerts
  },
  defaultMessage: 'Successfully updated {numAlerts} {numAlerts, plural, =1 {alert} other {alerts}}'
});
exports.CLOSE_ALERTS_SUCCESS = CLOSE_ALERTS_SUCCESS;
const CLOSE_ALERTS_ERROR = exports.CLOSE_ALERTS_ERROR = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.logic.closeAlerts.error', {
  defaultMessage: 'Failed to close alerts'
});