"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertSuppressionFieldsValidatorFactory = alertSuppressionFieldsValidatorFactory;
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function alertSuppressionFieldsValidatorFactory() {
  return _shared_imports.fieldValidators.maxLengthField({
    length: 3,
    message: _i18n.i18n.translate('xpack.securitySolution.ruleManagement.ruleCreation.validation.alertSuppressionFields.maxLengthError', {
      defaultMessage: 'Number of grouping fields must be at most 3'
    })
  });
}