"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MyAddItemButton = exports.AddItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var RuleI18n = _interopRequireWildcard(require("../../../common/translations"));
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/add_item_form/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyAddItemButton = exports.MyAddItemButton = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  margin: 4px 0px;
  font-size: 12px;

  .euiIcon {
    width: 12px;
    height: 12px;
  }
`;
MyAddItemButton.defaultProps = {
  flush: 'left',
  iconType: 'plusInCircle',
  size: 's'
};
const AddItem = ({
  addText,
  dataTestSubj,
  field,
  idAria,
  isDisabled,
  validate
}) => {
  const [showValidation, setShowValidation] = (0, _react.useState)(false);
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const [haveBeenKeyboardDeleted, setHaveBeenKeyboardDeleted] = (0, _react.useState)(-1);
  const inputsRef = (0, _react.useRef)([]);
  const removeItem = (0, _react.useCallback)(index => {
    const values = field.value;
    const newValues = [...values.slice(0, index), ...values.slice(index + 1)];
    field.setValue(newValues.length === 0 ? [''] : newValues);
    inputsRef.current = [...inputsRef.current.slice(0, index), ...inputsRef.current.slice(index + 1)];
    inputsRef.current = inputsRef.current.map((ref, i) => {
      if (i >= index && inputsRef.current[index] != null) {
        ref.value = 're-render';
      }
      return ref;
    });
  }, [field]);
  const addItem = (0, _react.useCallback)(() => {
    const values = field.value;
    field.setValue([...values, '']);
  }, [field]);
  const updateItem = (0, _react.useCallback)((event, index) => {
    const values = field.value;
    const value = event.target.value;
    field.setValue([...values.slice(0, index), value, ...values.slice(index + 1)]);
  }, [field]);
  const handleLastInputRef = (0, _react.useCallback)((index, element) => {
    if (element != null) {
      inputsRef.current = [...inputsRef.current.slice(0, index), element, ...inputsRef.current.slice(index + 1)];
    }
  }, [inputsRef]);
  (0, _react.useEffect)(() => {
    if (haveBeenKeyboardDeleted !== -1 && !(0, _fp.isEmpty)(inputsRef.current) && inputsRef.current[haveBeenKeyboardDeleted] != null) {
      inputsRef.current[haveBeenKeyboardDeleted].focus();
      setHaveBeenKeyboardDeleted(-1);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [haveBeenKeyboardDeleted, inputsRef.current]);
  const values = field.value;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    error: showValidation ? errorMessage : null,
    isInvalid: showValidation && isInvalid,
    fullWidth: true,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, values.map((item, index) => {
    const euiFieldProps = {
      disabled: isDisabled,
      ...(index === values.length - 1 ? {
        inputRef: handleLastInputRef.bind(null, index)
      } : {}),
      value: item,
      isInvalid: validate == null ? false : showValidation && validate(item)
    };
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      onBlur: () => setShowValidation(true),
      onChange: e => updateItem(e, index),
      fullWidth: true
    }, euiFieldProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "danger",
      iconType: "trash",
      isDisabled: isDisabled || (0, _fp.isEmpty)(item) && values.length === 1,
      onClick: () => removeItem(index),
      "aria-label": RuleI18n.DELETE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 19
      }
    }))), values.length - 1 !== index && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 47
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(MyAddItemButton, {
    onClick: addItem,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, addText)));
};
exports.AddItem = AddItem;