"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MUST_BE_POSITIVE_INTEGER_VALIDATION_ERROR = exports.MUST_BE_GREATER_THAN_ZERO_VALIDATION_ERROR = exports.HISTORY_WINDOW_START_LABEL = exports.HELP_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HISTORY_WINDOW_START_LABEL = exports.HISTORY_WINDOW_START_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.historyWindowSizeLabel', {
  defaultMessage: 'History Window Size'
});
const HELP_TEXT = exports.HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.historyWindowSizeHelpText', {
  defaultMessage: "New terms rules only alert if terms don't appear in historical data."
});
const MUST_BE_POSITIVE_INTEGER_VALIDATION_ERROR = exports.MUST_BE_POSITIVE_INTEGER_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.stepDefineRule.historyWindowSize.errNumber', {
  defaultMessage: 'History window size must be a positive number.'
});
const MUST_BE_GREATER_THAN_ZERO_VALIDATION_ERROR = exports.MUST_BE_GREATER_THAN_ZERO_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.stepDefineRule.historyWindowSize.errMin', {
  defaultMessage: 'History window size must be greater than 0.'
});