"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fleetIntegrationsApi = void 0;
var _fleet_integrations = require("../../../../common/api/detection_engine/fleet_integrations");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fleetIntegrationsApi = exports.fleetIntegrationsApi = {
  fetchAllIntegrations: args => {
    return http().fetch(_fleet_integrations.GET_ALL_INTEGRATIONS_URL, {
      method: 'GET',
      version: '1',
      signal: args.signal
    });
  },
  fetchInstalledIntegrations: args => {
    var _packages$sort;
    const {
      packages,
      signal
    } = args;
    return http().fetch(_fleet_integrations.GET_INSTALLED_INTEGRATIONS_URL, {
      method: 'GET',
      version: '1',
      query: {
        packages: packages === null || packages === void 0 ? void 0 : (_packages$sort = packages.sort()) === null || _packages$sort === void 0 ? void 0 : _packages$sort.join(',')
      },
      signal
    });
  }
};
const http = () => _kibana.KibanaServices.get().http;